/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.project;

import com.ohaotian.authority.dao.DictionariesMapper;
import com.ohaotian.authority.dao.ProjectInfoMapper;
import com.ohaotian.authority.po.DictionariesPO;
import com.ohaotian.authority.po.ProjectInfoPO;
import com.ohaotian.authority.project.bo.AuthProjectQryListServiceReqBO;
import com.ohaotian.authority.project.bo.ProjectInfoBO;
import com.ohaotian.authority.project.service.AuthProjectQryListService;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP_DEV/1.0.0/com.ohaotian.authority.project.service.AuthProjectQryListService"})
public class AuthProjectQryListServiceImpl
implements AuthProjectQryListService {
    private static final Logger log = LoggerFactory.getLogger(AuthProjectQryListServiceImpl.class);
    @Autowired
    private ProjectInfoMapper projectInfoMapper;
    @Autowired
    private DictionariesMapper dictionariesMapper;

    @PostMapping(value={"authProjectQryList"})
    public RspPage<ProjectInfoBO> authProjectQryList(@RequestBody AuthProjectQryListServiceReqBO reqBO) {
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        RspPage rspBO = new RspPage();
        ProjectInfoPO projectInfoPO = new ProjectInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)projectInfoPO);
        List<ProjectInfoPO> resultList = this.projectInfoMapper.selectListPage(projectInfoPO, page);
        if (StringUtils.isEmpty(resultList)) {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setCode("0");
            rspBO.setMessage("\u9879\u76ee\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        ArrayList<ProjectInfoBO> rows = new ArrayList<ProjectInfoBO>();
        for (ProjectInfoPO po : resultList) {
            ProjectInfoBO projectInfoBO = new ProjectInfoBO();
            BeanUtils.copyProperties((Object)po, (Object)projectInfoBO);
            projectInfoBO.setOrgId(po.getOrgIdWeb());
            if (projectInfoBO.getStatus() != null) {
                Long pid = 119L;
                DictionariesPO dictionariesPO = this.dictionariesMapper.selectDicByDicVal(pid, projectInfoBO.getStatus().toString());
                projectInfoBO.setStatusStr(dictionariesPO.getDicLabel());
            }
            rows.add(projectInfoBO);
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(rows);
        rspBO.setCode("0");
        rspBO.setMessage("\u9879\u76ee\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\u6210\u529f");
        return rspBO;
    }
}

