/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.web.impl.workday;

import com.ohaotian.authority.dao.SpecialDateMapper;
import com.ohaotian.authority.util.WorkDayUtils;
import com.ohaotian.authority.workday.bo.SelectWorkDayCountWebReqBO;
import com.ohaotian.authority.workday.bo.SelectWorkDayCountWebRspBO;
import com.ohaotian.authority.workday.bo.SpecialDateBO;
import com.ohaotian.authority.workday.service.SelectWorkDayCountWebService;
import com.ohaotian.plugin.common.util.DateUtils;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.workday.service.SelectWorkDayCountWebService"})
public class SelectWorkDayCountWebServiceImpl
implements SelectWorkDayCountWebService {
    private static final Logger log = LoggerFactory.getLogger(SelectWorkDayCountWebServiceImpl.class);
    @Autowired
    private SpecialDateMapper specialDateMapper;

    @PostMapping(value={"selectWorkDayCount"})
    public SelectWorkDayCountWebRspBO selectWorkDayCount(@RequestBody SelectWorkDayCountWebReqBO reqBO) {
        Date startdate = DateUtils.strToDate((String)reqBO.getStartTime());
        Date enddate = DateUtils.strToDate((String)reqBO.getEndTime());
        Long days = WorkDayUtils.workdayCount(reqBO.getStartTime(), reqBO.getEndTime());
        List<SpecialDateBO> specialDateBOS = this.specialDateMapper.selectHolidayCount(startdate, enddate);
        List<SpecialDateBO> weekDayCount = this.specialDateMapper.selectWeekDayCount(startdate, enddate);
        Long l = days - (long)specialDateBOS.size() - (long)WorkDayUtils.getWeekends(startdate, enddate) + (long)weekDayCount.size();
        SelectWorkDayCountWebRspBO rspBO = new SelectWorkDayCountWebRspBO();
        rspBO.setWorkdays(l);
        return rspBO;
    }
}

