/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.user.bo.UserIdBO;
import com.ohaotian.authority.user.service.ReopenUserStatusByUserIdService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.user.service.ReopenUserStatusByUserIdService"})
public class ReopenUserStatusByUserIdServiceImpl
implements ReopenUserStatusByUserIdService {
    private static final Logger log = LoggerFactory.getLogger(ReopenUserStatusByUserIdServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Resource(name="dataSend")
    private ProxyMessageProducer dataSend;
    @Value(value="${mq.authority.datasend.topic}")
    private String dataSendTopic;

    @Transactional
    @PostMapping(value={"reopenUserStatusByUserId"})
    public int reopenUserStatusByUserId(@RequestBody UserIdBO userIdBO) {
        if (userIdBO.getUserId() == null) {
            throw new ZTBusinessException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UserPO userPO = this.userMapper.selectUserInfo(userIdBO.getUserId());
        int result = this.userMapper.updateReopenUserByUserId(userIdBO);
        ProxyMessage proxyMessage = new ProxyMessage(this.dataSendTopic, "reopen_" + Constants.MQ_DATA_SEND_TAG_USER + "_" + userPO.getTenantId(), userIdBO.getUserId() + "");
        this.dataSend.send(proxyMessage);
        return result;
    }
}

