/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.role;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.po.Role;
import com.ohaotian.authority.role.bo.CreatRoleReqBO;
import com.ohaotian.authority.role.bo.SelectIdentityRepeatReqBO;
import com.ohaotian.authority.role.service.CreatRoleBusiService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.common.util.HanyuPinyinHelper;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="AUTH_GROUP_DEV", interfaceClass=CreatRoleBusiService.class)
public class CreatRoleBusiServiceImpl
implements CreatRoleBusiService {
    private static final Logger log = LoggerFactory.getLogger(CreatRoleBusiServiceImpl.class);
    @Autowired
    private RoleMapper roleMapper;
    @Resource(name="dataSend")
    private ProxyMessageProducer dataSend;
    @Value(value="${mq.authority.datasend.topic}")
    private String dataSendTopic;

    @Transactional
    public void creatRole(CreatRoleReqBO creatRoleReqBO) {
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("tenantId", creatRoleReqBO.getTenantIdReq());
        record.put("roleName", creatRoleReqBO.getRoleName());
        List<Role> roles = this.roleMapper.selectByRecord(record);
        if (roles != null && roles.size() > 0) {
            throw new ZTBusinessException("\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        creatRoleReqBO.setCreateUserId(creatRoleReqBO.getUserId());
        Role role = (Role)BeanMapper.map((Object)creatRoleReqBO, Role.class);
        role.setStatus(0);
        role.setTenantId(creatRoleReqBO.getTenantIdReq());
        String authIdentity = role.getAuthIdentity();
        if (StringUtils.isEmpty((Object)authIdentity)) {
            switch (creatRoleReqBO.getRoleType()) {
                case 1: {
                    authIdentity = "overall:" + HanyuPinyinHelper.getPinyinString((String)creatRoleReqBO.getRoleName());
                    break;
                }
                case 2: {
                    authIdentity = "part:" + HanyuPinyinHelper.getPinyinString((String)creatRoleReqBO.getRoleName());
                    break;
                }
                case 3: {
                    authIdentity = "tenant:" + creatRoleReqBO.getTenantIdReq() + ":" + HanyuPinyinHelper.getPinyinString((String)creatRoleReqBO.getRoleName());
                    break;
                }
                case 4: {
                    authIdentity = "manager:" + creatRoleReqBO.getTenantIdReq() + ":" + HanyuPinyinHelper.getPinyinString((String)creatRoleReqBO.getRoleName());
                    break;
                }
            }
            role.setAuthIdentity(authIdentity);
        } else {
            SelectIdentityRepeatReqBO repeatReqBO = new SelectIdentityRepeatReqBO();
            repeatReqBO.setAuthIdentity(authIdentity);
            if (role.getTenantId() == null) {
                List<Role> identityRepeatBO = this.roleMapper.selectIdentityRepeat(repeatReqBO);
                if (identityRepeatBO != null && identityRepeatBO.size() > 0) {
                    throw new ZTBusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u6743\u9650\u6807\u5fd7\u91cd\u590d");
                }
            } else {
                repeatReqBO.setTenantId(role.getTenantId());
                List<Role> identityRepeat = this.roleMapper.selectIdentityRepeat(repeatReqBO);
                if (identityRepeat != null && identityRepeat.size() > 0) {
                    throw new ZTBusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u6743\u9650\u6807\u5fd7\u91cd\u590d");
                }
            }
        }
        this.roleMapper.creatRole(role);
        ProxyMessage proxyMessage = new ProxyMessage(this.dataSendTopic, Constants.MQ_DATA_SEND_TAG_ROLE, role.getRoleId() + "");
        this.dataSend.send(proxyMessage);
    }
}

