/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.user.service.ResetPasswordService;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

@Service(version="1.0.0", group="AUTH_GROUP_DEV", interfaceClass=ResetPasswordService.class)
public class ResetPasswordServiceImpl
implements ResetPasswordService {
    private static final Logger log = LoggerFactory.getLogger(ResetPasswordServiceImpl.class);
    public static final String PWD = Constants.INITIAL_PASSWORD;
    @Value(value="${RESET_PWD:ysyhl9T@}")
    private String RESET_PWD;
    @Autowired
    private UserMapper userMapper;

    @Transactional(rollbackFor={Exception.class})
    public void resetPasswordByUserId(List<Long> userIds) {
        userIds.forEach(userId -> {
            UserPO userPO = new UserPO();
            userPO.setUserId((Long)userId);
            userPO.setInitialPassword(this.RESET_PWD);
            this.userMapper.updatePwdByUserId(userPO);
        });
    }
}

