/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.organisation;

import com.ohaotian.authority.dao.OrgRoleMapper;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.organisation.bo.SelectOrgByRoleIdReqBO;
import com.ohaotian.authority.organisation.bo.SelectOrgByRoleIdRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBO;
import com.ohaotian.authority.organisation.service.SelectOrgByRoleIdService;
import com.ohaotian.authority.po.OrgRolePO;
import com.ohaotian.authority.po.OrganisationPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="AUTH_GROUP_DEV", interfaceClass=SelectOrgByRoleIdService.class)
public class SelectOrgByRoleIdServiceImpl
implements SelectOrgByRoleIdService {
    private static final Logger log = LoggerFactory.getLogger(SelectOrgByRoleIdServiceImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private OrgRoleMapper orgRoleMapper;

    public SelectOrgByRoleIdRspBO selectOrgByRoleId(SelectOrgByRoleIdReqBO reqBO) {
        SelectOrgByRoleIdRspBO rspBO = new SelectOrgByRoleIdRspBO();
        ArrayList<Object> treePathRspBOS = new ArrayList<Object>();
        OrganisationPO organisationPO = new OrganisationPO();
        organisationPO = this.organizationMapper.selectOrgByAuthIdEntity(reqBO.getAuthIdEntity());
        if (organisationPO == null) {
            organisationPO = this.roleMapper.selectOrgByAuthIdentity(reqBO.getAuthIdEntity());
        }
        ArrayList<String> list3 = new ArrayList<String>();
        List<OrganisationPO> organisationPOS = this.organizationMapper.selectOrgBymUserId(reqBO.getUserId());
        for (OrganisationPO PO : organisationPOS) {
            list3.add(PO.getOrgTreePath());
        }
        ArrayList<String> list2 = new ArrayList<String>();
        if (organisationPO == null) {
            list2.addAll(list3);
        } else {
            list2.add(organisationPO.getOrgTreePath());
        }
        List<String> duplicate = SelectOrgByRoleIdServiceImpl.findDuplicate(list2, list3);
        if (duplicate != null && duplicate.size() > 0) {
            for (String manaOrg : duplicate) {
                OrganisationPO organisationPO1 = this.organizationMapper.selectOrganisationByOrgTreePath(manaOrg);
                List<TreePathRspBO> treePathRspBO = this.setRsp(organisationPO1);
                treePathRspBOS.addAll(treePathRspBO);
            }
        } else {
            List<String> duplicate2;
            ArrayList<String> list1 = new ArrayList<String>();
            List<OrgRolePO> orgRolePO = this.orgRoleMapper.selectRoleIdsByAuthIdentity(reqBO.getAuthIdEntity());
            if (orgRolePO != null && orgRolePO.size() > 0) {
                for (OrgRolePO PO : orgRolePO) {
                    list1.add(PO.getOrgTreePath());
                }
            }
            if ((duplicate2 = SelectOrgByRoleIdServiceImpl.findDuplicate(list1, list3)) != null && duplicate2.size() > 0) {
                List<Object> bos = new ArrayList();
                for (String str : duplicate2) {
                    OrganisationPO organisationPO1 = this.organizationMapper.selectOrganisationByOrgTreePath(str);
                    bos = this.setRsp(organisationPO1);
                    treePathRspBOS.addAll(bos);
                }
            }
        }
        rspBO.setTreePathRspBOS(treePathRspBOS);
        return rspBO;
    }

    public static void main(String[] args) {
        ArrayList<String> list1 = new ArrayList<String>();
        ArrayList<String> list2 = new ArrayList<String>();
        list1.add("1-116-297386708821872640-");
        list1.add("1-116-117-302432515965116416-");
        list1.add("c");
        list2.add("1-116-297386708821872640-");
        list2.add("1-116-117-302432515965116416-");
        List<String> duplicate = SelectOrgByRoleIdServiceImpl.findDuplicate(list1, list2);
        System.out.println("duplicate element: " + duplicate);
    }

    private static List<String> findDuplicate(List<String> list1, List<String> list2) {
        ArrayList<String> duplicate = new ArrayList<String>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ArrayList<String> list3 = new ArrayList<String>(new HashSet<String>(list1));
        ArrayList<String> list4 = new ArrayList<String>(new HashSet<String>(list2));
        for (String string : list3) {
            map.put(string, 1);
        }
        Iterator<Object> iterator = list4.iterator();
        while (iterator.hasNext()) {
            String string;
            map.put(string, map.get(string = (String)iterator.next()) == null ? 1 : 2);
        }
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() != 2) continue;
            duplicate.add((String)entry.getKey());
        }
        return duplicate;
    }

    public List<TreePathRspBO> setRsp(OrganisationPO organisationPO) {
        ArrayList<TreePathRspBO> obo = new ArrayList<TreePathRspBO>();
        TreePathRspBO treePathRspBO = new TreePathRspBO();
        BeanUtils.copyProperties((Object)organisationPO, (Object)treePathRspBO);
        treePathRspBO.setTenantName(treePathRspBO.getTitle());
        treePathRspBO.setOrgRootId(organisationPO.getOrgId());
        treePathRspBO.setOrganisationId(organisationPO.getOrgId());
        int i = this.organizationMapper.selectCountByPid(organisationPO.getOrgId());
        if (i > 0) {
            treePathRspBO.setIsParent(Integer.valueOf(0));
        } else {
            treePathRspBO.setIsParent(Integer.valueOf(1));
        }
        obo.add(treePathRspBO);
        return obo;
    }
}

