/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.station;

import com.ohaotian.authority.dao.ApplicationMapper;
import com.ohaotian.authority.dao.StationBusinessMapper;
import com.ohaotian.authority.dao.StationConfigMapper;
import com.ohaotian.authority.dao.StationSourceMapper;
import com.ohaotian.authority.po.Application;
import com.ohaotian.authority.po.StationBusiness;
import com.ohaotian.authority.po.StationConfig;
import com.ohaotian.authority.po.StationSource;
import com.ohaotian.authority.station.bo.SelectStaConfigByStaCodeReqBO;
import com.ohaotian.authority.station.bo.StationConfigBO;
import com.ohaotian.authority.station.service.SelectStaConfigByStaCodeService;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.db.Page;
import java.util.LinkedList;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="AUTH_GROUP_DEV", interfaceClass=SelectStaConfigByStaCodeService.class)
public class SelectStaConfigByStaCodeServiceImpl
implements SelectStaConfigByStaCodeService {
    private static final Logger log = LoggerFactory.getLogger(SelectStaConfigByStaCodeServiceImpl.class);
    @Autowired
    private StationConfigMapper stationConfigMapper;
    @Autowired
    private StationSourceMapper stationSourceMapper;
    @Autowired
    private StationBusinessMapper stationBusinessMapper;
    @Autowired
    private ApplicationMapper applicationMapper;

    public RspPage<StationConfigBO> selectStaConfigByStaCode(SelectStaConfigByStaCodeReqBO staConfigByStaCodeReqBO) {
        Page page = new Page(staConfigByStaCodeReqBO.getPageNo(), staConfigByStaCodeReqBO.getPageSize());
        List<StationConfig> stationConfigs = this.stationConfigMapper.selectConfigByCode(staConfigByStaCodeReqBO.getStationCode(), page);
        LinkedList<StationConfigBO> rspBO = new LinkedList<StationConfigBO>();
        for (StationConfig po : stationConfigs) {
            StationBusiness stationBusiness;
            StationConfigBO bo = (StationConfigBO)BeanMapper.map((Object)po, StationConfigBO.class);
            StationSource stationSource = this.stationSourceMapper.selectByBusiCodeAndSourceType(bo.getBusiCode(), bo.getSourceTypeCode());
            if (stationSource != null) {
                bo.setSourceTypeName(stationSource.getSourceTypeName());
            }
            if ((stationBusiness = this.stationBusinessMapper.selectByBusiCode(bo.getBusiCode())) != null) {
                bo.setBusiName(stationBusiness.getBusiName());
                Application application = this.applicationMapper.selectByAppCode(stationBusiness.getApplicationCode());
                if (application != null) {
                    bo.setApplicationName(application.getApplicationName());
                }
            }
            rspBO.add(bo);
        }
        RspPage rsp = new RspPage();
        rsp.setPageNo(staConfigByStaCodeReqBO.getPageNo());
        rsp.setTotal(page.getTotalPages());
        rsp.setRecordsTotal(page.getTotalCount());
        rsp.setRows(rspBO);
        return rsp;
    }
}

