/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.organisation;

import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.TenantMapper;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.bo.POrdIdBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBOS;
import com.ohaotian.authority.organisation.service.SelectOrgTreePathService;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.plugin.common.util.BeanMapper;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="AUTH_GROUP_DEV", interfaceClass=SelectOrgTreePathService.class)
public class SelectOrgTreePathImpl
implements SelectOrgTreePathService {
    private static final Logger log = LoggerFactory.getLogger(SelectOrgTreePathImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private TenantMapper tenantMapper;

    public TreePathRspBOS selectOrgTreePath(POrdIdBO pOrdIdBO) {
        String orderBy = "auto_code";
        if (StringUtils.isEmpty((CharSequence)pOrdIdBO.getOrderBy())) {
            pOrdIdBO.setOrderBy(orderBy);
        }
        OrganisationBO organisationBO = new OrganisationBO();
        organisationBO.setParentId(pOrdIdBO.getParentId());
        organisationBO.setmUserId(pOrdIdBO.getmUserId());
        organisationBO.setOrderBy(pOrdIdBO.getOrderBy());
        List<OrganisationPO> organisationPO = this.organizationMapper.selectOrgByPId(organisationBO);
        List treePathRspBO = organisationPO.stream().map(e -> {
            int i;
            TreePathRspBO treePathRsp = null;
            if (e != null) {
                treePathRsp = (TreePathRspBO)BeanMapper.map((Object)e, TreePathRspBO.class);
            }
            treePathRsp.setOrganisationId(e.getOrgId());
            TenantRspBO tenantRspBO = this.tenantMapper.selectTenantById(e.getTenantId());
            if (tenantRspBO != null) {
                treePathRsp.setTenantName(tenantRspBO.getTenantName());
                treePathRsp.setOrgRootId(tenantRspBO.getOrgRootId());
            }
            if ((i = this.organizationMapper.selectCountByPid(e.getOrgId())) > 0) {
                treePathRsp.setIsParent(Integer.valueOf(0));
            } else {
                treePathRsp.setIsParent(Integer.valueOf(1));
            }
            return treePathRsp;
        }).collect(Collectors.toList());
        TreePathRspBOS treePathRspBOS = new TreePathRspBOS();
        treePathRspBOS.setTreePathRspBOList(treePathRspBO);
        return treePathRspBOS;
    }
}

