/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.user.bo.DeleteUserReqBO;
import com.ohaotian.authority.user.service.DeleteUserService;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

@Service(version="1.0.0", group="AUTH_GROUP_DEV", interfaceClass=DeleteUserService.class)
public class DeleteUserServiceImpl
implements DeleteUserService {
    private static final Logger log = LoggerFactory.getLogger(DeleteUserServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private AuthDistributeMapper authDistributeMapper;
    @Resource(name="dataSend")
    private ProxyMessageProducer dataSend;
    @Value(value="${mq.authority.datasend.topic}")
    private String dataSendTopic;

    @Transactional
    public void deleteUserByUserId(DeleteUserReqBO userReqBO) {
        UserPO userPO = this.userMapper.selectUserInfo(userReqBO.getUserId());
        this.userMapper.deleteUserByUserId(userReqBO.getUserId());
        this.userMapper.deleteByExtSysUser(userReqBO.getUserId());
        this.userMapper.deleteUserStation(userReqBO.getUserId());
        this.authDistributeMapper.deleteByUserId(userReqBO.getUserId());
        this.organizationMapper.updateMuserIdNull(userReqBO.getUserId());
        ProxyMessage proxyMessage = new ProxyMessage(this.dataSendTopic, "delete_" + Constants.MQ_DATA_SEND_TAG_USER + "_" + userPO.getTenantId(), userReqBO.getUserId() + "");
        this.dataSend.send(proxyMessage);
    }
}

