/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.resourceTenant;

import com.ohaotian.authority.dao.ProjectInfoMapper;
import com.ohaotian.authority.dao.ResourceTenantMapper;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.service.DeleteOrganizationServer;
import com.ohaotian.authority.organisation.service.StopOrganisationByOrgId;
import com.ohaotian.authority.po.ProjectInfoPO;
import com.ohaotian.authority.po.ResourceTenantPO;
import com.ohaotian.authority.resourceTenant.bo.ResourceTenantReqBO;
import com.ohaotian.authority.resourceTenant.service.AuthResTenantUpdateService;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="AUTH_GROUP_DEV", interfaceClass=AuthResTenantUpdateService.class)
public class AuthResTenantUpdateServiceImpl
implements AuthResTenantUpdateService {
    private static final Logger log = LoggerFactory.getLogger(AuthResTenantUpdateServiceImpl.class);
    @Autowired
    private ResourceTenantMapper resourceTenantMapper;
    @Autowired
    private ProjectInfoMapper projectInfoMapper;
    @Autowired
    private DeleteOrganizationServer deleteOrganizationServer;
    @Autowired
    private StopOrganisationByOrgId stopOrganisationByOrgId;

    public RspBaseBO updateResTenant(ResourceTenantReqBO reqBO) {
        int update;
        RspBaseBO rspBO = new RspBaseBO();
        this.initParam(reqBO);
        ResourceTenantPO resourceTenantPO = new ResourceTenantPO();
        resourceTenantPO.setResTenantId(reqBO.getResTenantId());
        ResourceTenantPO result = this.resourceTenantMapper.selectByPrimaryKey(resourceTenantPO);
        if (result == null) {
            throw new ZTBusinessException("\u8d44\u6e90\u79df\u6237\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)resourceTenantPO);
        resourceTenantPO.setUpdateUserId(reqBO.getUserId());
        resourceTenantPO.setUpdateTime(new Date());
        if (resourceTenantPO.getStatus() != null) {
            if (resourceTenantPO.getStatus() == 1) {
                OrganisationIdReqBO stopOrgReqBO = new OrganisationIdReqBO();
                stopOrgReqBO.setOrganisationId(result.getOrgId());
                this.stopOrganisationByOrgId.stopOrganisationByOrgId(stopOrgReqBO);
            } else if (resourceTenantPO.getStatus() == 2) {
                ProjectInfoPO projectInfoPO = new ProjectInfoPO();
                projectInfoPO.setOrgIdWeb(result.getOrgId());
                List<ProjectInfoPO> resultList = this.projectInfoMapper.selectList(projectInfoPO);
                if (resultList != null && resultList.size() > 0) {
                    throw new ZTBusinessException("\u5f53\u524d\u8d44\u6e90\u79df\u6237\u4e0b\u5b58\u5728\u6709\u6548\u9879\u76ee\uff0c\u7981\u6b62\u5220\u9664\u8be5\u8d44\u6e90\u79df\u6237");
                }
                OrganisationIdReqBO delOrgReqBO = new OrganisationIdReqBO();
                delOrgReqBO.setOrganisationId(result.getOrgId());
                this.deleteOrganizationServer.deleteOrganization(delOrgReqBO);
            }
        }
        if ((update = this.resourceTenantMapper.update(resourceTenantPO)) < 1) {
            throw new ZTBusinessException("\u8d44\u6e90\u79df\u6237\u7ef4\u62a4\u5931\u8d25");
        }
        rspBO.setCode("0");
        rspBO.setMessage("\u8d44\u6e90\u79df\u6237\u7ef4\u62a4\u6210\u529f");
        return rspBO;
    }

    private void initParam(ResourceTenantReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getResTenantId()) {
            throw new ZTBusinessException("\u5165\u53c2\u8d44\u6e90\u79df\u6237id[resTenantId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

