/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.web.impl.user;

import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.user.bo.AddNewExtUserBindWebReqBO;
import com.ohaotian.authority.user.bo.AddNewExtUserBindWebRspBO;
import com.ohaotian.authority.user.bo.SelectUserByLoginNameRspBO;
import com.ohaotian.authority.user.service.AddNewExtUserBindWebService;
import com.ohaotian.authority.util.EncryptUtils;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(version="1.0.0", group="AUTH_GROUP_DEV", interfaceClass=AddNewExtUserBindWebService.class)
public class AddNewExtUserBindWebServiceImpl
implements AddNewExtUserBindWebService {
    private static final Logger log = LoggerFactory.getLogger(AddNewExtUserBindWebServiceImpl.class);
    Logger logger = LoggerFactory.getLogger(AddNewExtUserBindWebServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Value(value="${password.encryptType:SHA-256}")
    private String encryptType;
    @Autowired
    private EncryptUtils encryptUtils;

    public AddNewExtUserBindWebRspBO addNewExtUserBind(AddNewExtUserBindWebReqBO addNewExtUserBindWebReqBO) {
        SelectUserByLoginNameRspBO userInfo = this.userMapper.selectUserByLoginName(addNewExtUserBindWebReqBO.getLoginName());
        AddNewExtUserBindWebRspBO addNewExtUserBindWebRspBO = new AddNewExtUserBindWebRspBO();
        if (userInfo != null) {
            if (StringUtils.isNotEmpty((CharSequence)userInfo.getInitialPassword())) {
                if (addNewExtUserBindWebReqBO.getPassWord().equals(userInfo.getInitialPassword())) {
                    return this.addNewBind(userInfo.getUserId(), addNewExtUserBindWebReqBO.getExtSystemType(), addNewExtUserBindWebReqBO.getExtUserId());
                }
                addNewExtUserBindWebRspBO.setCode("1");
                addNewExtUserBindWebRspBO.setMessage("\u767b\u5f55\u540d\u6216\u5bc6\u7801\u9519\u8bef");
                return addNewExtUserBindWebRspBO;
            }
            if (!this.encryptType.equals("SHA-256")) {
                String decryptFirst = this.encryptUtils.decryptByType(userInfo.getPassword(), this.encryptType);
                this.logger.info("\u7b2c\u4e00\u6b21\u89e3\u5bc6\uff1a" + decryptFirst);
                decryptFirst.substring(0, decryptFirst.length() - userInfo.getSalt().length());
                this.logger.info("\u53bb\u6389\u76d0\u503c\uff1a" + decryptFirst.substring(0, decryptFirst.length() - userInfo.getSalt().length()));
                String decryptSecond = this.encryptUtils.decryptByType(decryptFirst.substring(0, decryptFirst.length() - userInfo.getSalt().length()), this.encryptType);
                this.logger.info("\u7b2c\u4e8c\u6b21\u89e3\u5bc6\uff1adecryptSecond = {},password = {}", (Object)decryptSecond, (Object)addNewExtUserBindWebReqBO.getPassWord());
                if (decryptSecond.equals(addNewExtUserBindWebReqBO.getPassWord())) {
                    return this.addNewBind(userInfo.getUserId(), addNewExtUserBindWebReqBO.getExtSystemType(), addNewExtUserBindWebReqBO.getExtUserId());
                }
                addNewExtUserBindWebRspBO.setCode("1");
                addNewExtUserBindWebRspBO.setMessage("\u767b\u5f55\u540d\u6216\u5bc6\u7801\u9519\u8bef");
                return addNewExtUserBindWebRspBO;
            }
            String encrypt = this.encryptUtils.encryptByType(addNewExtUserBindWebReqBO.getPassWord(), this.encryptType);
            String pwd = this.encryptUtils.encryptByType(encrypt + userInfo.getSalt(), this.encryptType);
            if (pwd.equals(userInfo.getPassword())) {
                return this.addNewBind(userInfo.getUserId(), addNewExtUserBindWebReqBO.getExtSystemType(), addNewExtUserBindWebReqBO.getExtUserId());
            }
            addNewExtUserBindWebRspBO.setCode("1");
            addNewExtUserBindWebRspBO.setMessage("\u767b\u5f55\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            return addNewExtUserBindWebRspBO;
        }
        addNewExtUserBindWebRspBO.setCode("1");
        addNewExtUserBindWebRspBO.setMessage("\u767b\u5f55\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        return addNewExtUserBindWebRspBO;
    }

    public AddNewExtUserBindWebRspBO addNewBind(Long newUserId, String extSystemType, String extUserId) {
        AddNewExtUserBindWebRspBO addNewExtUserBindWebRspBO = new AddNewExtUserBindWebRspBO();
        Long userIdByExtId = this.userMapper.getUserIdByExtId(extSystemType, extUserId);
        if (userIdByExtId != null) {
            addNewExtUserBindWebRspBO.setCode("1");
            addNewExtUserBindWebRspBO.setMessage("\u8be5\u4e09\u65b9\u5e10\u53f7\u5df2\u88ab\u7ed1\u5b9a");
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userId", newUserId);
            map.put("extSystemType", extSystemType);
            map.put("extUserId", extUserId);
            map.put("state", 1);
            map.put("defaultStatus", 1);
            this.userMapper.insertConditionExtUser(map);
            addNewExtUserBindWebRspBO.setCode("0");
            addNewExtUserBindWebRspBO.setMessage("\u6210\u529f");
        }
        return addNewExtUserBindWebRspBO;
    }
}

