/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.login;

import com.ohaotian.authority.login.bo.LoginGetPicVfCodeReqBO;
import com.ohaotian.authority.login.bo.LoginGetPicVfCodeRspBO;
import com.ohaotian.authority.login.service.LoginGetPicVfCodeService;
import com.ohaotian.authority.util.VerifyCodeUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Service(version="1.0.0", group="AUTH_GROUP", interfaceClass=LoginGetPicVfCodeService.class)
public class LoginGetPicVfCodeServiceImpl
implements LoginGetPicVfCodeService {
    private static final Logger log = LoggerFactory.getLogger(LoginGetPicVfCodeServiceImpl.class);
    private static final Integer DEFUALT_CODE_LENGTH = 4;
    private static final Integer PIC_WIGTH = 80;
    private static final Integer PIC_HEIGHT = 30;
    private Base64 base64 = new Base64();
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${picVfCodeExpTime:300}")
    private int picVfCodeExpTime;
    private static final String VF_CODE_KEY = "picVfCode";

    public LoginGetPicVfCodeRspBO getPicVfCode(LoginGetPicVfCodeReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getIp())) {
            throw new ZTBusinessException("\u5165\u53c2[ip]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LoginGetPicVfCodeRspBO rspBO = new LoginGetPicVfCodeRspBO();
        if (null == reqBO.getVfCodeLength()) {
            reqBO.setVfCodeLength(DEFUALT_CODE_LENGTH);
        }
        String code = VerifyCodeUtils.generateVerifyCode(reqBO.getVfCodeLength());
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u56fe\u7247\u9a8c\u8bc1\u7801:{}", (Object)code);
        }
        if (null == reqBO.getPicHeight() || null == reqBO.getPicWidth()) {
            reqBO.setPicHeight(PIC_HEIGHT);
            reqBO.setPicWidth(PIC_WIGTH);
        }
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        try {
            Object obj = this.cacheClient.get("picVfCode_" + reqBO.getIp());
            if (null != obj) {
                this.cacheClient.delete("picVfCode_" + reqBO.getIp());
            }
            VerifyCodeUtils.outputImage((int)reqBO.getPicWidth(), (int)reqBO.getPicHeight(), fos, code);
            rspBO.setPicVfCode(this.base64.encodeToString(fos.toByteArray()));
            rspBO.setVfCode(code);
            this.cacheClient.set("picVfCode_" + reqBO.getIp(), (Object)code, this.picVfCodeExpTime);
            fos.close();
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u83b7\u53d6\u9a8c\u8bc1\u7801\u56fe\u7247\u5931\u8d25");
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                log.error(e.getMessage());
                throw new ZTBusinessException("\u5173\u95ed\u5b57\u8282\u6d41\u5931\u8d25");
            }
        }
        rspBO.setCode("0");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }

    public LoginGetPicVfCodeRspBO checkVfCode(LoginGetPicVfCodeReqBO reqBO) {
        this.initParam(reqBO);
        Object obj = this.cacheClient.get("picVfCode_" + reqBO.getIp());
        if (null == obj || !reqBO.getVfCode().equals(String.valueOf(obj))) {
            throw new ZTBusinessException("\u9a8c\u8bc1\u7801\u5931\u6548");
        }
        if (log.isDebugEnabled()) {
            log.debug("key:{}", (Object)(String.valueOf(obj) + "_" + reqBO.getIp()));
        }
        this.cacheClient.delete(VF_CODE_KEY + reqBO.getIp());
        LoginGetPicVfCodeRspBO rspBO = new LoginGetPicVfCodeRspBO();
        rspBO.setCode("0");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }

    private void initParam(LoginGetPicVfCodeReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getVfCode())) {
            throw new ZTBusinessException("\u5165\u53c2\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getIp())) {
            throw new ZTBusinessException("\u5165\u53c2ip\u4e3a\u7a7a");
        }
    }
}

