/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.manager;

import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.dao.OrgRoleMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.manager.bo.SaveAdminGrantRolesReqBO;
import com.ohaotian.authority.manager.service.SaveAdminGrantRolesBusiService;
import com.ohaotian.authority.po.OrgRolePO;
import com.ohaotian.authority.po.Role;
import com.ohaotian.authority.util.RoleGrantReqUtils;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Service(version="1.0.0", group="AUTH_GROUP", interfaceClass=SaveAdminGrantRolesBusiService.class)
public class SaveAdminGrantRolesBusiServiceImpl
implements SaveAdminGrantRolesBusiService {
    private static final Logger log = LoggerFactory.getLogger(SaveAdminGrantRolesBusiServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SaveAdminGrantRolesBusiServiceImpl.class);
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private OrgRoleMapper orgRoleMapper;
    @Autowired
    AuthDistributeMapper authDistributeMapper;

    @Transactional
    public void saveAdminGrantRoles(SaveAdminGrantRolesReqBO reqBO) {
        Set<Long> delete;
        String orgTreePath = reqBO.getOrgTreePath();
        String json = reqBO.getJson();
        logger.info("orgTreePath====" + orgTreePath + ",json=====" + json);
        Map<String, Set<Long>> stringSetMap = RoleGrantReqUtils.otherGrant(json);
        Set<Long> add = stringSetMap.get("add");
        if (add != null && add.size() > 0) {
            logger.info("\u65b0\u589e\u7684\u89d2\u8272id\u96c6\u5408===" + add.toString());
            add.forEach(e -> {
                logger.info("\u65b0\u589e\u7684\u89d2\u8272id===" + String.valueOf(e));
                Role role = this.roleMapper.selectByPrimaryKey((Long)e);
                OrgRolePO PO = this.orgRoleMapper.selectByOrgTreePathAndRole(orgTreePath, role.getAuthIdentity());
                if (PO == null) {
                    logger.info("\u65b0\u589eorgRole\u8868\u5165\u53c2orgTreePath===" + orgTreePath + ",RoleAuthIdentity===" + role.getAuthIdentity());
                    OrgRolePO record = new OrgRolePO();
                    record.setOrgTreePath(orgTreePath);
                    record.setRoleAuthIdentity(role.getAuthIdentity());
                    this.orgRoleMapper.insert(record);
                }
            });
        }
        if ((delete = stringSetMap.get("delete")) != null && delete.size() > 0) {
            delete.forEach(e -> {
                logger.info("\u5220\u9664\u7684\u89d2\u8272id===" + String.valueOf(e));
                Role role = this.roleMapper.selectByPrimaryKey((Long)e);
                this.orgRoleMapper.deleteByOrgTreePath(orgTreePath, role.getAuthIdentity());
                this.authDistributeMapper.deleteByManaOrgTreePathAndRole(orgTreePath, (Long)e);
                this.orgRoleMapper.deleteLikeByOrgTreePath(orgTreePath, role.getAuthIdentity());
                this.authDistributeMapper.deleteLikeByManaOrgTreePathAndRole(orgTreePath, (Long)e);
            });
        }
    }
}

