/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.manager;

import com.ohaotian.authority.dao.OrgStationMapper;
import com.ohaotian.authority.dao.StationMapper;
import com.ohaotian.authority.manager.bo.SaveAdminGrantStationsReqBO;
import com.ohaotian.authority.manager.service.SaveAdminGrantStationsBusiService;
import com.ohaotian.authority.po.OrgStationPO;
import com.ohaotian.authority.po.Station;
import com.ohaotian.authority.util.RoleGrantReqUtils;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="AUTH_GROUP", interfaceClass=SaveAdminGrantStationsBusiService.class)
public class SaveAdminGrantStationsBusiServiceImpl
implements SaveAdminGrantStationsBusiService {
    private static final Logger log = LoggerFactory.getLogger(SaveAdminGrantStationsBusiServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(SaveAdminGrantStationsBusiServiceImpl.class);
    @Autowired
    private OrgStationMapper orgStationMapper;
    @Autowired
    private StationMapper stationMapper;

    public void saveAdminGrantStationsBusi(SaveAdminGrantStationsReqBO reqBO) {
        Set<Long> delete;
        String orgTreePath = reqBO.getOrgTreePath();
        String json = reqBO.getJson();
        logger.info("orgTreePath====" + orgTreePath, (Object)("json=====" + json));
        Map<String, Set<Long>> stringSetMap = RoleGrantReqUtils.otherGrant(json);
        Set<Long> add = stringSetMap.get("add");
        if (add != null && add.size() > 0) {
            logger.info("\u65b0\u589e\u7684\u5c97\u4f4did\u96c6\u5408===" + add.toString());
            add.forEach(e -> {
                logger.info("\u65b0\u589e\u7684\u5c97\u4f4did===" + String.valueOf(e));
                Station station = this.stationMapper.selectByPrimaryKey((Long)e);
                OrgStationPO PO = this.orgStationMapper.selectByOrgTreePathAndStation(orgTreePath, station.getStationId());
                if (PO == null) {
                    logger.info("\u65b0\u589eorgStation\u8868\u5165\u53c2orgTreePath===" + orgTreePath + ",\u5c97\u4f4did===" + station.getStationId());
                    OrgStationPO record = new OrgStationPO();
                    record.setOrgTreePath(orgTreePath);
                    record.setStationId(station.getStationId());
                    this.orgStationMapper.insert(record);
                }
            });
        }
        if ((delete = stringSetMap.get("delete")) != null && delete.size() > 0) {
            delete.forEach(e -> {
                logger.info("\u5220\u9664\u7684\u5c97\u4f4did===" + String.valueOf(e));
                Station station = this.stationMapper.selectByPrimaryKey((Long)e);
                this.orgStationMapper.deleteByOrgTreePathAndStation(orgTreePath, station.getStationId());
            });
        }
    }
}

