/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.manager;

import com.ohaotian.authority.dao.ManagerRoleMapper;
import com.ohaotian.authority.dao.OrgMenuMapper;
import com.ohaotian.authority.manager.bo.SaveMgrPublishMenusReqBO;
import com.ohaotian.authority.manager.service.SaveMgrPublishMenusService;
import com.ohaotian.authority.util.RoleGrantReqUtils;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Service(version="1.0.0", group="AUTH_GROUP", interfaceClass=SaveMgrPublishMenusService.class)
public class SaveMgrPublishMenusServiceImpl
implements SaveMgrPublishMenusService {
    private static final Logger log = LoggerFactory.getLogger(SaveMgrPublishMenusServiceImpl.class);
    @Autowired
    private ManagerRoleMapper managerRoleMapper;
    @Autowired
    private OrgMenuMapper orgMenuMapper;

    @Transactional
    public void saveMgrPublishMenus(SaveMgrPublishMenusReqBO saveMgrPublishMenusReqBO) {
        String roleIdentity = saveMgrPublishMenusReqBO.getRoleIdentity();
        String json = saveMgrPublishMenusReqBO.getJson();
        Map<String, Set<Long>> stringSetMap = RoleGrantReqUtils.roleConfig(json);
        Set<Long> adds = stringSetMap.get("add");
        Set<Long> deletes = stringSetMap.get("delete");
        adds.forEach(add -> this.managerRoleMapper.saveMgrPublishMenu(roleIdentity, (Long)add));
        deletes.forEach(delete -> {
            this.managerRoleMapper.deleteMgrPublishMenu(roleIdentity, (Long)delete);
            if (roleIdentity.equals("auth:tenant:manage")) {
                this.managerRoleMapper.deleteMgrPublishMenu(roleIdentity, (Long)delete);
                this.orgMenuMapper.deleteByMenuId((Long)delete);
            }
        });
    }
}

