/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.organisation;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.service.ReopenOrganisationByOrgId;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

@Service(version="1.0.0", group="AUTH_GROUP", interfaceClass=ReopenOrganisationByOrgId.class)
public class ReopenOrganisationByOrgIdImpl
implements ReopenOrganisationByOrgId {
    private static final Logger log = LoggerFactory.getLogger(ReopenOrganisationByOrgIdImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Resource(name="dataSend")
    private ProxyMessageProducer dataSend;
    @Value(value="${mq.authority.datasend.topic}")
    private String dataSendTopic;
    @Value(value="${mq.enable}")
    private String mqEnable;

    @Transactional
    public void reopenOrganisationByOrgId(OrganisationIdReqBO organisationBO) {
        OrganisationPO porganisation;
        OrganisationPO organisation = this.organizationMapper.selectOrganisationByOrgId(organisationBO.getOrganisationId());
        if (organisation.getParentId() != null && (porganisation = this.organizationMapper.selectOrganisationByOrgId(organisation.getParentId())).getStatus() != 0) {
            throw new ZTBusinessException("\u5f53\u524d\u673a\u6784\u4e0d\u53ef\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\u4e0a\u7ea7\u72b6\u6001\u662f\u5426\u6709\u6548");
        }
        this.organizationMapper.reopenOrganisationByOrgTreePath(organisation.getOrgTreePath());
        if ("true".equals(this.mqEnable)) {
            List<OrganisationPO> organisationPOS = this.organizationMapper.selectByTreePath(organisation.getOrgTreePath());
            for (OrganisationPO organisationPO : organisationPOS) {
                ProxyMessage proxyMessage = new ProxyMessage(this.dataSendTopic, "reopen_" + Constants.MQ_DATA_SEND_TAG_ORGANISATION + "_" + organisationPO.getTenantId(), organisationPO.getOrgId() + "");
                this.dataSend.send(proxyMessage);
            }
        }
    }
}

