/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.role;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.po.AuthDistribute;
import com.ohaotian.authority.role.bo.HasAndNotGrantRoleBO;
import com.ohaotian.authority.role.bo.SaveOrgGrantUsersReqBO;
import com.ohaotian.authority.role.service.SaveOrgGrantUsersBusiService;
import com.ohaotian.plugin.db.Sequence;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Service(version="1.0.0", group="AUTH_GROUP", interfaceClass=SaveOrgGrantUsersBusiService.class)
public class SaveOrgGrantUsersBusiServiceImpl
implements SaveOrgGrantUsersBusiService {
    private static final Logger log = LoggerFactory.getLogger(SaveOrgGrantUsersBusiServiceImpl.class);
    @Autowired
    private AuthDistributeMapper authDistributeMapper;

    @Transactional
    public void saveOrgGrantUsers(SaveOrgGrantUsersReqBO saveOrgGrantUsersReqBO) {
        List userBOList = saveOrgGrantUsersReqBO.getUserBOList();
        List<HasAndNotGrantRoleBO> hasAndNotGrantRoleBOS = this.authDistributeMapper.selectOrgExtendRoles(saveOrgGrantUsersReqBO.getOrgTreePath());
        userBOList.removeAll(hasAndNotGrantRoleBOS);
        this.authDistributeMapper.deleteBySingleOrg(saveOrgGrantUsersReqBO.getOrgTreePath());
        userBOList.forEach(userBO -> {
            AuthDistribute authDistribute = new AuthDistribute();
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            authDistribute.setAuthId(l);
            authDistribute.setDisFlag(Constants.DISTRIBUTE_TYPE_ORG);
            authDistribute.setOrgTreePath(saveOrgGrantUsersReqBO.getOrgTreePath());
            authDistribute.setUserId(userBO.getUserId());
            authDistribute.setRoleId(saveOrgGrantUsersReqBO.getRoleId());
            this.authDistributeMapper.insert(authDistribute);
        });
    }
}

