/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.role;

import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.dao.OrgRoleMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.organisation.bo.SelectOrgByMuserIdReqBO;
import com.ohaotian.authority.organisation.bo.SelectOrgByMuserIdRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBO;
import com.ohaotian.authority.organisation.service.SelectOrgByMuserIdService;
import com.ohaotian.authority.role.bo.HasAndNotGrantRoleBO;
import com.ohaotian.authority.role.bo.SelectRolesByOrgTreePathReqBO;
import com.ohaotian.authority.role.bo.SelectRolesByOrgTreePathRspBO;
import com.ohaotian.authority.role.service.SelectRolesByOrgTreePathBusiService;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@Service(version="1.0.0", group="AUTH_GROUP", interfaceClass=SelectRolesByOrgTreePathBusiService.class)
public class SelectRolesByOrgTreePathBusiServiceImpl
implements SelectRolesByOrgTreePathBusiService {
    private static final Logger log = LoggerFactory.getLogger(SelectRolesByOrgTreePathBusiServiceImpl.class);
    @Autowired
    RoleMapper roleMapper;
    @Autowired
    AuthDistributeMapper authDistributeMapper;
    @Autowired
    OrgRoleMapper orgRoleMapper;
    @Autowired
    SelectOrgByMuserIdService selectOrgByMuserIdService;

    public SelectRolesByOrgTreePathRspBO select(SelectRolesByOrgTreePathReqBO reqBO) {
        SelectRolesByOrgTreePathRspBO rspBO = new SelectRolesByOrgTreePathRspBO();
        ArrayList<HasAndNotGrantRoleBO> hasGrantRoles = new ArrayList<HasAndNotGrantRoleBO>();
        String orgTreePath = reqBO.getOrgTreePath();
        Long tenantId = reqBO.getTenantIdReq();
        if (reqBO.getUserId() != null) {
            SelectOrgByMuserIdReqBO muserId = new SelectOrgByMuserIdReqBO();
            muserId.setmUserId(reqBO.getUserId());
            SelectOrgByMuserIdRspBO mOrgList = this.selectOrgByMuserIdService.selectOrgByMuserId(muserId);
            ArrayList<String> list1 = new ArrayList<String>();
            if (mOrgList.getTreePathRspBOS() != null) {
                for (TreePathRspBO morg : mOrgList.getTreePathRspBOS()) {
                    list1.add(morg.getOrgTreePath());
                }
            }
            for (String Str : list1) {
                boolean contains = orgTreePath.contains(Str);
                if (!contains) continue;
                orgTreePath = Str;
            }
        } else {
            orgTreePath = "1-";
        }
        List<HasAndNotGrantRoleBO> hasGrantRoles1 = this.roleMapper.selectRoleIdsByOrgTreePath(null, orgTreePath, tenantId);
        List<HasAndNotGrantRoleBO> hasAndNotGrantRoleBOS = this.orgRoleMapper.selectRoleIdsByOrgTreePath(orgTreePath);
        if (!CollectionUtils.isEmpty(hasGrantRoles1)) {
            hasGrantRoles.addAll(hasGrantRoles1);
        }
        if (!CollectionUtils.isEmpty(hasAndNotGrantRoleBOS)) {
            hasGrantRoles.addAll(hasAndNotGrantRoleBOS);
        }
        rspBO.setHasGrantRoles(hasGrantRoles);
        return rspBO;
    }
}

