/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.tenant;

import com.ohaotian.authority.dao.TenantMapper;
import com.ohaotian.authority.tenant.bo.AppConfigBO;
import com.ohaotian.authority.tenant.service.CreateAppFroTenantService;
import com.ohaotian.authority.util.RoleGrantReqUtils;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Service(version="1.0.0", group="AUTH_GROUP", interfaceClass=CreateAppFroTenantService.class)
public class CreateAppFroTenantServiceImpl
implements CreateAppFroTenantService {
    private static final Logger log = LoggerFactory.getLogger(CreateAppFroTenantServiceImpl.class);
    @Autowired
    TenantMapper tenantMapper;

    @Transactional
    public void createAppforTenant(AppConfigBO appConfigForTenantReqBO) {
        Long tenantId = appConfigForTenantReqBO.getTenantId();
        String configDetail = appConfigForTenantReqBO.getConfigDetail();
        Map<String, Set<Long>> stringSetMap = RoleGrantReqUtils.otherGrant(configDetail);
        Set<Long> adds = stringSetMap.get("add");
        Set<Long> deletes = stringSetMap.get("delete");
        adds.forEach(add -> this.tenantMapper.saveAppConfig(tenantId, (Long)add));
        deletes.forEach(delete -> this.tenantMapper.deleteAppConfig(tenantId, (Long)delete));
    }
}

