/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.tenant;

import com.ohaotian.authority.dao.TenantMapper;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.service.CreateOrganisationService;
import com.ohaotian.authority.po.TenantPO;
import com.ohaotian.authority.tenant.bo.CreateTenantBO;
import com.ohaotian.authority.tenant.service.CreateTenantService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import java.util.Date;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.annotation.Transactional;

@Service(version="1.0.0", group="AUTH_GROUP", interfaceClass=CreateTenantService.class)
public class CreateTenantServiceImpl
implements CreateTenantService {
    private static final Logger log = LoggerFactory.getLogger(CreateTenantServiceImpl.class);
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private CreateOrganisationService createOrganisationService;

    @Transactional
    public void insertTenant(CreateTenantBO createTenantBO) {
        TenantPO tenantPO = new TenantPO();
        tenantPO.setTenantId(createTenantBO.getTenantId());
        tenantPO.setRemark(createTenantBO.getRemark());
        tenantPO.setTenantName(createTenantBO.getTenantName());
        try {
            this.tenantMapper.insertTenant(tenantPO);
            OrganisationBO organisationBO = new OrganisationBO();
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            organisationBO.setOrganisationId(Long.valueOf(l));
            organisationBO.setParentId(Long.valueOf(1L));
            organisationBO.setTitle(createTenantBO.getTenantName());
            organisationBO.setCreatTime(new Date());
            organisationBO.setTenantId(tenantPO.getTenantId());
            Long orgId = this.createOrganisationService.createOrganisation(organisationBO);
            this.tenantMapper.updateOrgIdByTenantId(tenantPO.getTenantId(), orgId);
        }
        catch (DuplicateKeyException e) {
            throw new ZTBusinessException("\u79df\u6237\u540d\u79f0\u4e0d\u80fd\u91cd\u590d!");
        }
    }
}

