/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.station;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.StationMapper;
import com.ohaotian.authority.po.Station;
import com.ohaotian.authority.station.bo.SelectStationsByStationCodePageReqBO;
import com.ohaotian.authority.station.bo.SelectStationsByStationCodePageRspBO;
import com.ohaotian.authority.station.bo.StationToUccBO;
import com.ohaotian.authority.station.service.SelectStationsByStationCodePageService;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="AUTH_GROUP_DEV", interfaceClass=SelectStationsByStationCodePageService.class)
public class SelectStationsByStationCodePageServiceImpl
implements SelectStationsByStationCodePageService {
    private static final Logger log = LoggerFactory.getLogger(SelectStationsByStationCodePageServiceImpl.class);
    @Autowired
    private StationMapper stationMapper;

    public SelectStationsByStationCodePageRspBO selectStationsByStationPage(SelectStationsByStationCodePageReqBO reqBO) {
        SelectStationsByStationCodePageRspBO rspBO = new SelectStationsByStationCodePageRspBO();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<Station> stations = this.stationMapper.selectUserStationByStationPage(reqBO.getAttributeName(), page);
        ArrayList<StationToUccBO> stationToUccBOS = new ArrayList<StationToUccBO>();
        for (Station station : stations) {
            StationToUccBO stationBO = new StationToUccBO();
            if (null != station.getStationId()) {
                stationBO.setAttributeName(station.getStationId().toString());
            }
            if (null != station.getStationCode()) {
                stationBO.setAttributeDesc(station.getStationCode());
            }
            if (null != station.getStationName()) {
                stationBO.setDefaultAttributeValue(station.getStationName());
            }
            stationBO.setAttributeType(Constants.TYPE_STRING);
            stationToUccBOS.add(stationBO);
        }
        rspBO.setRows(stationToUccBOS);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        return rspBO;
    }
}

