/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.role;

import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.role.bo.HasAndNotGrantRoleBO;
import com.ohaotian.authority.role.bo.SelectUserRolesReqBO;
import com.ohaotian.authority.role.bo.SelectUserRolesRspBO;
import com.ohaotian.authority.role.service.SelectUserRolesBusiService;
import java.util.LinkedList;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="AUTH_GROUP_DEV", interfaceClass=SelectUserRolesBusiService.class)
public class SelectUserRolesBusiServiceImpl
implements SelectUserRolesBusiService {
    private static final Logger log = LoggerFactory.getLogger(SelectUserRolesBusiServiceImpl.class);
    @Autowired
    private AuthDistributeMapper authDistributeMapper;

    public SelectUserRolesRspBO selectUserRoles(SelectUserRolesReqBO userRolesReqBO) {
        List<HasAndNotGrantRoleBO> hasAndNotGrantRoleBOS = this.authDistributeMapper.selectRoleByUserId(userRolesReqBO.getUserId());
        SelectUserRolesRspBO rspBO = new SelectUserRolesRspBO();
        LinkedList<HasAndNotGrantRoleBO> userRoles = new LinkedList<HasAndNotGrantRoleBO>();
        LinkedList<HasAndNotGrantRoleBO> orgRoles = new LinkedList<HasAndNotGrantRoleBO>();
        if (hasAndNotGrantRoleBOS != null && hasAndNotGrantRoleBOS.size() > 0) {
            for (HasAndNotGrantRoleBO roleBO : hasAndNotGrantRoleBOS) {
                if (roleBO.getCanSel() == 0) {
                    userRoles.add(roleBO);
                    continue;
                }
                orgRoles.add(roleBO);
            }
        }
        rspBO.setOrgRoles(orgRoles);
        rspBO.setUserRoles(userRoles);
        return rspBO;
    }
}

