/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.login;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.login.bo.LoginExpTimeReqBO;
import com.ohaotian.authority.login.bo.LoginExpTimeRspBO;
import com.ohaotian.authority.login.service.LoginService;
import com.ohaotian.plugin.cache.CacheClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV", serviceInterface=LoginService.class)
public class LoginServiceImpl
implements LoginService {
    private static final Logger log = LoggerFactory.getLogger(LoginServiceImpl.class);
    public static String LOGIN_EXP_TIME = "LoginExpTime";
    @Autowired
    private CacheClient cacheService;
    @Value(value="${login.expTime:7200}")
    private Long expTime;

    public LoginExpTimeRspBO getLoginExpTime(LoginExpTimeReqBO reqBO) {
        LoginExpTimeRspBO rspBO = new LoginExpTimeRspBO();
        rspBO.setExpTime((Long)this.cacheService.get(reqBO.getToken() + LOGIN_EXP_TIME));
        rspBO.setCode("0");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }

    public LoginExpTimeRspBO updateLoginExpTime(LoginExpTimeReqBO reqBO) {
        LoginExpTimeRspBO rspBO = new LoginExpTimeRspBO();
        Long newExpTime = System.currentTimeMillis() + this.expTime * 1000L;
        this.cacheService.set(reqBO.getToken() + LOGIN_EXP_TIME, (Object)newExpTime);
        rspBO.setCode("0");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }

    public LoginExpTimeRspBO logOut(LoginExpTimeReqBO reqBO) {
        LoginExpTimeRspBO rspBO = new LoginExpTimeRspBO();
        this.cacheService.delete(reqBO.getToken() + LOGIN_EXP_TIME);
        rspBO.setCode("0");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }
}

