/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.role;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.dao.OrgRoleMenuMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.po.OrgRoleMenuPO;
import com.ohaotian.authority.po.RoleAutoPO;
import com.ohaotian.authority.role.bo.SaveRoleConfigMenusReqBO;
import com.ohaotian.authority.role.service.SaveRoleConfigMenusBusiService;
import com.ohaotian.authority.util.RoleGrantReqUtils;
import com.ohaotian.plugin.db.Sequence;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV", serviceInterface=SaveRoleConfigMenusBusiService.class)
public class SaveRoleConfigMenusBusiServiceImpl
implements SaveRoleConfigMenusBusiService {
    private static final Logger log = LoggerFactory.getLogger(SaveRoleConfigMenusBusiServiceImpl.class);
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private OrgRoleMenuMapper orgRoleMenuMapper;

    public void saveRoleConfigMenus(SaveRoleConfigMenusReqBO saveRoleConfigMenusReqBO) {
        String orgTreePath = saveRoleConfigMenusReqBO.getOrgTreePath();
        Long roleId = saveRoleConfigMenusReqBO.getRoleId();
        String configDetail = saveRoleConfigMenusReqBO.getConfigDetail();
        Map<String, Set<Long>> stringSetMap = RoleGrantReqUtils.roleConfig(configDetail);
        Set<Long> adds = stringSetMap.get("add");
        Set<Long> deletes = stringSetMap.get("delete");
        for (Long add : adds) {
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            this.roleMapper.saveRoleAuto(l, roleId, add);
            if (!"auth:org:manage".equals(saveRoleConfigMenusReqBO.getAuthIdentity())) continue;
            OrgRoleMenuPO record = new OrgRoleMenuPO();
            record.setOrgTreePath(orgTreePath);
            record.setRoleAutoId(l);
            this.orgRoleMenuMapper.insert(record);
        }
        for (Long delete : deletes) {
            RoleAutoPO roleAutoPO;
            if ("auth:org:manage".equals(saveRoleConfigMenusReqBO.getAuthIdentity()) && (roleAutoPO = this.roleMapper.selectRoleAutoByRoleAndMenu(roleId, delete)) != null) {
                this.orgRoleMenuMapper.deleteByOrgAndRole(orgTreePath, roleAutoPO.getAuthId());
            }
            this.roleMapper.deleteRoleAuto(roleId, delete);
        }
    }
}

