/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.web.impl.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.user.bo.ChangePwdWebReqBO;
import com.ohaotian.authority.user.service.ChangePwdByUserIdWebService;
import com.ohaotian.authority.util.EncryptUtils;
import com.ohaotian.authority.util.SaltUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV", serviceInterface=ChangePwdByUserIdWebService.class)
public class ChangePwdByUserIdWebServiceImpl
implements ChangePwdByUserIdWebService {
    private static final Logger log = LoggerFactory.getLogger(ChangePwdByUserIdWebServiceImpl.class);
    Logger logger = LoggerFactory.getLogger(ChangePwdByUserIdWebServiceImpl.class);
    @Autowired
    UserMapper userMapper;
    @Value(value="${password.encryptType:SHA-256}")
    private String encryptType;
    @Autowired
    private EncryptUtils encryptUtils;
    @Value(value="${CHECK_LASTPWD_FLAG:true}")
    private Boolean CHECK_LASTPWD_FLAG;

    @Transactional
    public void changePasswordByUserId(ChangePwdWebReqBO webReqBO) {
        Long userId = webReqBO.getUserIdReq();
        if (userId == null) {
            userId = webReqBO.getUserId();
        }
        String newEncrypt = this.encryptUtils.encryptByType(webReqBO.getPasswordReq(), this.encryptType);
        UserPO userPO = this.userMapper.selectUserInfo(userId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userPO.getInitialPassword()}) && userPO.getInitialPassword().equals(webReqBO.getPasswordReq())) {
            throw new ZTBusinessException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u65e7\u5bc6\u7801\u76f8\u540c");
        }
        String salt = userPO.getSalt();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{salt})) {
            if (this.encryptType.equals("SHA-256")) {
                String newPwd;
                String newPwdEncrypt = this.encryptUtils.encryptByType(webReqBO.getPasswordReq(), this.encryptType);
                String newpwd = this.encryptUtils.encryptByType(newPwdEncrypt + userPO.getSalt(), this.encryptType);
                if (newpwd.equals(userPO.getPassword())) {
                    throw new ZTBusinessException("\u65b0\u5bc6\u7801\u4e0e\u539f\u5bc6\u7801\u4e0d\u53ef\u76f8\u540c\uff01");
                }
                if (this.CHECK_LASTPWD_FLAG.equals(true) && !StringUtils.isEmpty((CharSequence)userPO.getField4()) && !StringUtils.isEmpty((CharSequence)userPO.getField3()) && (newPwd = this.encryptUtils.encryptByType(newPwdEncrypt + userPO.getField4(), this.encryptType)).equals(userPO.getField3())) {
                    throw new ZTBusinessException("\u65b0\u5bc6\u7801\u4e0e\u4e0a\u4e00\u6b21\u5bc6\u7801\u4e0d\u53ef\u76f8\u540c\uff01");
                }
            } else {
                String decryptFirst = this.encryptUtils.decryptByType(userPO.getPassword(), "SM2");
                this.logger.info("\u7b2c\u4e00\u6b21\u89e3\u5bc6\uff1a" + decryptFirst);
                this.logger.info("\u53bb\u6389\u76d0\u503c\uff1a" + decryptFirst.substring(0, decryptFirst.length() - userPO.getSalt().length()));
                String decryptSecond = this.encryptUtils.decryptByType(decryptFirst.substring(0, decryptFirst.length() - userPO.getSalt().length()), "SM2");
                this.logger.info("\u7b2c\u4e8c\u6b21\u89e3\u5bc6\uff1adecryptSecond = {},oldpassword = {}", (Object)decryptSecond, (Object)webReqBO.getPasswordReq());
                if (decryptSecond.equals(webReqBO.getPasswordReq())) {
                    this.logger.info("\u5339\u914d\u6210\u529f:{},{}", (Object)decryptSecond, (Object)webReqBO.getPasswordReq());
                    throw new ZTBusinessException("\u65b0\u5bc6\u7801\u4e0e\u539f\u5bc6\u7801\u4e0d\u53ef\u76f8\u540c\uff01");
                }
                if (this.CHECK_LASTPWD_FLAG.equals(true) && !StringUtils.isEmpty((CharSequence)userPO.getField4()) && !StringUtils.isEmpty((CharSequence)userPO.getField3())) {
                    String decryptFirstField3 = this.encryptUtils.decryptByType(userPO.getField3(), "SM2");
                    String decryptSecondField3 = this.encryptUtils.decryptByType(decryptFirstField3.substring(0, decryptFirstField3.length() - userPO.getField4().length()), "SM2");
                    if (userPO.getField3() != null && decryptSecondField3.equals(webReqBO.getPasswordReq())) {
                        this.logger.info("\u5339\u914d\u6210\u529f", (Object)decryptSecond, (Object)webReqBO.getPasswordReq());
                        throw new ZTBusinessException("\u65b0\u5bc6\u7801\u4e0e\u4e0a\u4e00\u6b21\u5bc6\u7801\u4e0d\u53ef\u76f8\u540c\uff01");
                    }
                }
            }
        }
        String newSalt = SaltUtils.getSerialNo(8);
        String newPwd = this.encryptUtils.encryptByType(newEncrypt + newSalt, this.encryptType);
        UserPO newUser = new UserPO();
        newUser.setUserId(userId);
        newUser.setSalt(newSalt);
        newUser.setPassword(newPwd);
        Date now = new Date();
        newUser.setEffDate(now);
        this.userMapper.updateByPrimaryKeySelective(newUser);
    }
}

