/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.user.bo.SelectUserByRoleAndOrgWebReqBO;
import com.ohaotian.authority.user.bo.SelectUserByRoleAndOrgWebRspBO;
import com.ohaotian.authority.user.bo.SelectUserInfoWebBO;
import com.ohaotian.authority.user.service.SelectUserByRoleAndOrgWebService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV", serviceInterface=SelectUserByRoleAndOrgWebService.class)
public class SelectUserByRoleAndOrgWebServiceImpl
implements SelectUserByRoleAndOrgWebService {
    private static final Logger log = LoggerFactory.getLogger(SelectUserByRoleAndOrgWebServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OrganizationMapper organizationMapper;

    public SelectUserByRoleAndOrgWebRspBO selectUserByRoleAndOrg(SelectUserByRoleAndOrgWebReqBO reqBO) {
        this.initParam(reqBO);
        SelectUserByRoleAndOrgWebRspBO rspBO = new SelectUserByRoleAndOrgWebRspBO();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<UserPO> userPOs = this.userMapper.selectUserByRoleAndOrg(reqBO, page);
        ArrayList<SelectUserInfoWebBO> selectUserInfoWebBOList = new ArrayList<SelectUserInfoWebBO>();
        for (UserPO userPO : userPOs) {
            SelectUserInfoWebBO selectUserInfoWebBO = new SelectUserInfoWebBO();
            selectUserInfoWebBO.setUserId(userPO.getUserId());
            selectUserInfoWebBO.setLoginName(userPO.getLoginName());
            selectUserInfoWebBO.setName(userPO.getName());
            selectUserInfoWebBO.setCellPhone(userPO.getCellPhone());
            selectUserInfoWebBO.setStatus(userPO.getStatus());
            selectUserInfoWebBOList.add(selectUserInfoWebBO);
        }
        if (reqBO.getOrgIdWeb() != null) {
            OrganisationPO orgInfo = this.organizationMapper.selectOrganisationByOrgId(reqBO.getOrgIdWeb());
            rspBO.setTitle(orgInfo.getTitle());
        }
        rspBO.setOrgId(reqBO.getOrgIdWeb());
        rspBO.setRows(selectUserInfoWebBOList);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        return rspBO;
    }

    private void initParam(SelectUserByRoleAndOrgWebReqBO reqBO) {
        if (null == reqBO.getOrgIdWeb()) {
            throw new ZTBusinessException("\u5165\u53c2\u673a\u6784Id[orgIdWeb]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

