/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.web.impl.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.user.bo.AddUserWebReqBO;
import com.ohaotian.authority.user.bo.SelectUserByCellphoneBO;
import com.ohaotian.authority.user.bo.SelectUserByLoginNameRspBO;
import com.ohaotian.authority.user.service.AddPortalUserWebService;
import com.ohaotian.authority.util.EncryptUtils;
import com.ohaotian.authority.util.SaltUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV", serviceInterface=AddPortalUserWebService.class)
public class AddPortalUserWebServiceImpl
implements AddPortalUserWebService {
    private static final Logger log = LoggerFactory.getLogger(AddPortalUserWebServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Value(value="${password.encryptType:SHA-256}")
    private String encryptType;
    @Autowired
    private EncryptUtils encryptUtils;

    @Transactional(rollbackFor={Exception.class})
    public Long insertUser(AddUserWebReqBO webReqBO) {
        List<SelectUserByCellphoneBO> selectUserByCellphoneBOS;
        UserPO userPO = new UserPO();
        userPO.setRegisterType(webReqBO.getRegisterType());
        userPO.setUserId(webReqBO.getUserIdReq());
        userPO.setLoginName(webReqBO.getLoginNameReq().toLowerCase());
        userPO.setCellPhone(webReqBO.getCellPhoneReq());
        userPO.setName(webReqBO.getName());
        String encrypt = this.encryptUtils.encryptByType(webReqBO.getPasswordReq(), this.encryptType);
        String salt = SaltUtils.getSerialNo(8);
        userPO.setSalt(salt);
        String pwd = this.encryptUtils.encryptByType(encrypt + salt, this.encryptType);
        userPO.setPassword(pwd);
        userPO.setSource(2);
        if (webReqBO.getSource() != null) {
            userPO.setSource(webReqBO.getSource());
        }
        userPO.setDetailSource(webReqBO.getDetialSource());
        userPO.setStatus(0);
        userPO.setField5(webReqBO.getRegisterSource());
        if ("register:personal".equals(webReqBO.getRegisterType()) && (selectUserByCellphoneBOS = this.userMapper.selectUserByCellphone(webReqBO.getCellPhoneReq(), "false")) != null && selectUserByCellphoneBOS.size() > 0) {
            throw new ZTBusinessException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u7ed1\u5b9a");
        }
        SelectUserByLoginNameRspBO selectUserByLoginNameRspBO = this.userMapper.selectUserByLoginName(webReqBO.getLoginNameReq().toLowerCase());
        if (selectUserByLoginNameRspBO != null) {
            throw new ZTBusinessException("\u7528\u6237\u767b\u5f55\u540d\u4e0d\u80fd\u91cd\u590d");
        }
        this.userMapper.insertUser(userPO);
        return userPO.getUserId();
    }
}

