/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.manager;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.dao.ManagerOrgMapper;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.manager.bo.AddManagerReqBO;
import com.ohaotian.authority.manager.service.AddManagerBusiService;
import com.ohaotian.authority.po.AuthDistribute;
import com.ohaotian.authority.po.ManagerOrg;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.authority.po.Role;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP", serviceInterface=AddManagerBusiService.class)
public class AddManagerBusiServiceImpl
implements AddManagerBusiService {
    public static final Logger log = LoggerFactory.getLogger(AddManagerBusiServiceImpl.class);
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private AuthDistributeMapper authDistributeMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private ManagerOrgMapper managerOrgMapper;

    @Transactional
    public void addManager(AddManagerReqBO addManagerReqBO) {
        log.debug("orgid\uff1a" + addManagerReqBO.getOrgIds());
        log.debug("\u65b0\u589e\u673a\u6784\u7ba1\u7406\u5458\u5165\u53c2\uff1a" + addManagerReqBO.toString());
        Role manager = this.roleMapper.selectRoleByAuthId("auth:org:manage");
        AuthDistribute authDistributeBO = this.authDistributeMapper.selectByUserIdAndRoleId(addManagerReqBO.getMgrUserId(), manager.getRoleId());
        if (authDistributeBO == null) {
            AuthDistribute authDistribute = new AuthDistribute();
            authDistribute.setAuthId(addManagerReqBO.getAuthId());
            authDistribute.setDisFlag(Constants.DISTRIBUTE_TYPE_USER);
            authDistribute.setRoleId(manager.getRoleId());
            authDistribute.setUserId(addManagerReqBO.getMgrUserId());
            this.authDistributeMapper.insert(authDistribute);
            UserPO userPO = new UserPO();
            userPO.setUserId(addManagerReqBO.getMgrUserId());
            userPO.setType(manager.getAuthIdentity());
            this.userMapper.updateByPrimaryKeySelective(userPO);
        }
        log.debug("\u6743\u9650\u5206\u914d\u8868\u67e5\u8be2\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)authDistributeBO));
        List longs = JSON.parseArray((String)addManagerReqBO.getOrgIds(), Long.class);
        log.debug("longs\u65e5\u5fd71:" + longs);
        if (longs.get(0) == null) {
            throw new ZTBusinessException("\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.debug("longs\u65e5\u5fd7:" + longs);
        List<OrganisationPO> orgPOS = this.organizationMapper.selectOrgLikeTreePath(addManagerReqBO.getMgrUserId(), longs);
        log.debug("orgPOS\u65e5\u5fd7:" + orgPOS);
        if (orgPOS.size() >= 1) {
            throw new ZTBusinessException("\u8be5\u7528\u6237\u4e0d\u53ef\u7ba1\u7406\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u7ba1\u7406\u4e0b\u7ea7\u673a\u6784");
        }
        this.organizationMapper.updateOrgMuserId(longs, addManagerReqBO.getMgrUserId());
        ArrayList<ManagerOrg> list = new ArrayList<ManagerOrg>();
        for (Long orgId : longs) {
            ManagerOrg managerOrg = new ManagerOrg();
            managerOrg.setOrgId(orgId);
            managerOrg.setUserId(addManagerReqBO.getMgrUserId());
            list.add(managerOrg);
        }
        this.managerOrgMapper.insertBatch(list);
    }
}

