/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.mq;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.mq.bo.DelRoleSendMsgBO;
import com.ohaotian.authority.mq.bo.DelRoleSendMsgReqBO;
import com.ohaotian.authority.mq.service.DelRoleSendMsgService;
import com.ohaotian.authority.po.Role;
import com.ohaotian.authority.user.bo.SelectUserInfoWebBO;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP", serviceInterface=DelRoleSendMsgService.class)
public class DelRoleSendMsgServiceImpl
implements DelRoleSendMsgService {
    private static final Logger log = LoggerFactory.getLogger(DelRoleSendMsgServiceImpl.class);
    @Resource(name="authDelRoleMqServiceProvider")
    private ProxyMessageProducer authDelRoleMqServiceProvider;
    @Value(value="${UMC_CANCEL_DISPATCH_CID:CID_CANCEL_DISPATCH}")
    private String UMC_CANCEL_DISPATCH_CID;
    @Value(value="${UMC_CANCEL_DISPATCH_TOPIC:UMC_CANCEL_DISPATCH_TOPIC}")
    private String UMC_CANCEL_DISPATCH_TOPIC;
    @Value(value="${UMC_CANCEL_DISPATCH_TAG:*}")
    private String UMC_CANCEL_DISPATCH_TAG;
    private static String OPER_TYPE_MEM_INVALID = "2";
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private RoleMapper roleMapper;

    public void delRoleSendMsg(DelRoleSendMsgReqBO reqBO) {
        Role role;
        if (log.isDebugEnabled()) {
            log.debug("\u5165\u53c2:{}", (Object)reqBO);
        }
        if (null != (role = this.roleMapper.selectByPrimaryKey(reqBO.getRoleId()))) {
            List<SelectUserInfoWebBO> userInfoBOS = this.userMapper.selectUserInfoByIds(reqBO.getUserIds());
            ArrayList delRoleSendMsgBOS = new ArrayList();
            userInfoBOS.forEach(bo -> {
                DelRoleSendMsgBO delRoleSendMsgBO = new DelRoleSendMsgBO();
                delRoleSendMsgBO.setAuthIdentity(role.getAuthIdentity());
                delRoleSendMsgBO.setLoginName(bo.getLoginName());
                delRoleSendMsgBO.setOrgId(String.valueOf(bo.getOrgId()));
                delRoleSendMsgBO.setOperType(OPER_TYPE_MEM_INVALID);
                delRoleSendMsgBOS.add(delRoleSendMsgBO);
            });
            if (log.isDebugEnabled()) {
                log.debug("\u53d1\u9001\u6d88\u606f\u53c2\u6570:{}", delRoleSendMsgBOS);
            }
            if (!CollectionUtils.isEmpty(delRoleSendMsgBOS)) {
                this.authDelRoleMqServiceProvider.send(new ProxyMessage(this.UMC_CANCEL_DISPATCH_TOPIC, this.UMC_CANCEL_DISPATCH_TAG, JSON.toJSONString(delRoleSendMsgBOS)));
            }
        }
    }
}

