/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.organisation;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.service.StopOrganisationByOrgId;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP", serviceInterface=StopOrganisationByOrgId.class)
public class StopOrganisationByOrgIdImpl
implements StopOrganisationByOrgId {
    private static final Logger log = LoggerFactory.getLogger(StopOrganisationByOrgIdImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Resource(name="dataSend")
    private ProxyMessageProducer dataSend;
    @Value(value="${mq.authority.datasend.topic}")
    private String dataSendTopic;
    @Value(value="${mq.enable}")
    private String mqEnable;

    @Transactional
    public void stopOrganisationByOrgId(OrganisationIdReqBO organisationBO) {
        OrganisationPO organisation = this.organizationMapper.selectOrganisationByOrgId(organisationBO.getOrganisationId());
        this.organizationMapper.updateOrganisationByOrgTreePath(organisation.getOrgTreePath());
        if ("true".equals(this.mqEnable)) {
            List<OrganisationPO> organisationPOS = this.organizationMapper.selectByTreePath(organisation.getOrgTreePath());
            for (OrganisationPO organisationPO : organisationPOS) {
                ProxyMessage proxyMessage = new ProxyMessage(this.dataSendTopic, "stop_" + Constants.MQ_DATA_SEND_TAG_ORGANISATION + "_" + organisationPO.getTenantId(), organisationPO.getOrgId() + "");
                this.dataSend.send(proxyMessage);
            }
        }
    }
}

