/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.resourceTenant;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.dao.DictionariesMapper;
import com.ohaotian.authority.dao.ResourceTenantMapper;
import com.ohaotian.authority.po.DictionariesPO;
import com.ohaotian.authority.po.ResourceTenantPO;
import com.ohaotian.authority.resourceTenant.bo.AuthResTenantQryListServiceReqBO;
import com.ohaotian.authority.resourceTenant.bo.ResourceTenantRspBO;
import com.ohaotian.authority.resourceTenant.service.AuthResTenantQryListService;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP", serviceInterface=AuthResTenantQryListService.class)
public class AuthResTenantQryListServiceImpl
implements AuthResTenantQryListService {
    private static final Logger log = LoggerFactory.getLogger(AuthResTenantQryListServiceImpl.class);
    @Autowired
    private ResourceTenantMapper resourceTenantMapper;
    @Autowired
    private DictionariesMapper dictionariesMapper;

    public RspPage<ResourceTenantRspBO> qryResTenantList(AuthResTenantQryListServiceReqBO reqBO) {
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        RspPage rspBO = new RspPage();
        ResourceTenantPO resourceTenantPO = new ResourceTenantPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)resourceTenantPO);
        List<ResourceTenantPO> resultList = this.resourceTenantMapper.selectListPage(resourceTenantPO, page);
        if (StringUtils.isEmpty(resultList)) {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setCode("0");
            rspBO.setMessage("\u8d44\u6e90\u79df\u6237\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        ArrayList<ResourceTenantRspBO> rows = new ArrayList<ResourceTenantRspBO>();
        for (ResourceTenantPO po : resultList) {
            ResourceTenantRspBO resourceTenantBO = new ResourceTenantRspBO();
            BeanUtils.copyProperties((Object)po, (Object)resourceTenantBO);
            if (resourceTenantBO.getStatus() != null) {
                Long pid = 118L;
                DictionariesPO dictionariesPO = this.dictionariesMapper.selectDicByDicVal(pid, resourceTenantBO.getStatus().toString());
                resourceTenantBO.setStatusStr(dictionariesPO.getDicLabel());
            }
            rows.add(resourceTenantBO);
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(rows);
        rspBO.setCode("0");
        rspBO.setMessage("\u8d44\u6e90\u79df\u6237\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u6210\u529f");
        return rspBO;
    }
}

