/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.user.bo.RegisterIndividualUserReqBO;
import com.ohaotian.authority.user.bo.RegisterIndividualUserRspBO;
import com.ohaotian.authority.user.bo.SelectUserByLoginNameRspBO;
import com.ohaotian.authority.user.service.RegisterIndividualUserOAuth2Service;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP", serviceInterface=RegisterIndividualUserOAuth2Service.class)
public class RegisterIndividualUserOAuth2ServiceImpl
implements RegisterIndividualUserOAuth2Service {
    private static final Logger log = LoggerFactory.getLogger(RegisterIndividualUserOAuth2ServiceImpl.class);
    @Autowired
    private UserMapper userMapper;

    @Transactional
    public RegisterIndividualUserRspBO registerIndividualUser(RegisterIndividualUserReqBO reqBO) {
        UserPO addUserPO = new UserPO();
        addUserPO.setUserId(reqBO.getUserId());
        addUserPO.setName(reqBO.getName());
        addUserPO.setEmail(reqBO.getEmail());
        addUserPO.setCellPhone(reqBO.getCellPhone());
        addUserPO.setStatus(reqBO.getStatus());
        addUserPO.setRegisterType(reqBO.getRegisterType() == null ? "register:personal" : reqBO.getRegisterType());
        addUserPO.setSource(1);
        addUserPO.setInitialPassword(this.getStringRandom(8));
        this.userMapper.insertUser(addUserPO);
        UserPO medUserPO = new UserPO();
        medUserPO.setUserId(addUserPO.getUserId());
        String loginName = this.ctreatLoginName(reqBO.getRegisterWay());
        medUserPO.setLoginName(loginName);
        this.userMapper.updateByPrimaryKeySelective(medUserPO);
        this.userMapper.insertExtUser(addUserPO.getUserId(), reqBO.getOauth2Id(), reqBO.getRegisterWay());
        RegisterIndividualUserRspBO rspBO = new RegisterIndividualUserRspBO();
        rspBO.setUserId(addUserPO.getUserId());
        return rspBO;
    }

    private String ctreatLoginName(String registerWay) {
        SelectUserByLoginNameRspBO nameRspBO;
        String loginName = null;
        while ((nameRspBO = this.userMapper.selectUserByLoginName(loginName = registerWay + this.getStringRandom(4))) != null && !StringUtils.isBlank((CharSequence)nameRspBO.getLoginName())) {
        }
        return loginName;
    }

    private String getStringRandom(int length) {
        String val = "";
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val = val + (char)(random.nextInt(26) + temp);
                continue;
            }
            if (!"num".equalsIgnoreCase(charOrNum)) continue;
            val = val + String.valueOf(random.nextInt(10));
        }
        return val.toLowerCase();
    }
}

