/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.user.service.ResetPasswordService;
import com.ohaotian.plugin.cache.CacheClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP", serviceInterface=ResetPasswordService.class)
public class ResetPasswordServiceImpl
implements ResetPasswordService {
    private static final Logger log = LoggerFactory.getLogger(ResetPasswordServiceImpl.class);
    public static final String PWD = Constants.INITIAL_PASSWORD;
    @Value(value="${INITIAL_PASSWORD:ysyhl9T@}")
    private String RESET_PWD;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private CacheClient cacheClient;

    @Transactional(rollbackFor={Exception.class})
    public void resetPasswordByUserId(List<Long> userIds) {
        userIds.forEach(userId -> {
            UserPO userPO = new UserPO();
            userPO.setUserId((Long)userId);
            userPO.setInitialPassword(this.RESET_PWD);
            this.userMapper.updatePwdByUserId(userPO);
            UserPO result = this.userMapper.selectUserInfo((Long)userId);
            this.cacheClient.delete("cas" + result.getLoginName());
            this.cacheClient.delete("cas" + result.getCellPhone());
        });
    }
}

