/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.user.bo.SelectUserByLoginNameReqBO;
import com.ohaotian.authority.user.bo.SelectUserByLoginNameRspBO;
import com.ohaotian.authority.user.service.SelectUserByLoginNameService;
import com.ohaotian.authority.util.EncryptUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP", serviceInterface=SelectUserByLoginNameService.class)
public class SelectUserByLoginNameServiceImpl
implements SelectUserByLoginNameService {
    private static final Logger log = LoggerFactory.getLogger(SelectUserByLoginNameServiceImpl.class);
    Logger logger = LoggerFactory.getLogger(SelectUserByLoginNameServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Value(value="${login.needsend:false}")
    private boolean needSendlogin;
    @Value(value="${password.encryptType:SHA-256}")
    private String encryptType;
    @Autowired
    private EncryptUtils encryptUtils;

    public SelectUserByLoginNameRspBO selectUserByLoginNameService(SelectUserByLoginNameReqBO selectUserByLoginNameReqBO) {
        this.logger.info("\u767b\u5f55\u5339\u914d\u7528\u6237\u540d\u5165\u53c2\uff1a" + selectUserByLoginNameReqBO.toString());
        String phoneregexp = "^[1][3,4,5,7,8][0-9]{9}$";
        String emailregexp = "^[a-z0-9]+([._\\-]*[a-z0-9])*@([a-z0-9]+[-a-z0-9]*[a-z0-9]+.){1,63}[a-z0-9]+$";
        String loginName = selectUserByLoginNameReqBO.getUsername();
        String password = selectUserByLoginNameReqBO.getPassword();
        String type = selectUserByLoginNameReqBO.getType();
        if (StringUtils.isBlank((CharSequence)password) || StringUtils.isBlank((CharSequence)loginName)) {
            return null;
        }
        SelectUserByLoginNameRspBO userInfo = this.userMapper.selectUserByLoginName(loginName);
        this.logger.info("\u6570\u636e\u5e93\u83b7\u53d6userInfo\uff1a" + JSON.toJSONString((Object)userInfo));
        if (userInfo != null) {
            this.logger.debug("type\uff1a" + type);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{type})) {
                this.logger.debug("\u516c\u4f17\u7528\u6237type\uff1a" + userInfo.getRegisterType());
                if (!type.equals(userInfo.getRegisterType())) {
                    this.logger.debug("\u516c\u4f17\u7528\u6237type\uff1a" + type);
                    return null;
                }
            } else if (StringUtils.isEmpty((CharSequence)userInfo.getType())) {
                this.logger.debug("\u540e\u53f0\u7528\u6237type\uff1a" + userInfo.getType());
                return null;
            }
            this.logger.debug("\u521d\u59cb\u5bc6\u7801\uff1a" + userInfo.getInitialPassword());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userInfo.getInitialPassword()})) {
                this.logger.debug("\u521d\u59cb\u5bc6\u7801\uff1a\u8fdb\u5165");
                if (password.equals(userInfo.getInitialPassword())) {
                    this.logger.debug("\u521d\u59cb\u5bc6\u7801\uff1a\u6210\u529f");
                    return userInfo;
                }
            } else if (!this.encryptType.equals("SHA-256")) {
                String decryptFirst = this.encryptUtils.decryptByType(userInfo.getPassword(), this.encryptType);
                this.logger.info("\u7b2c\u4e00\u6b21\u89e3\u5bc6\uff1a" + decryptFirst);
                decryptFirst.substring(0, decryptFirst.length() - userInfo.getSalt().length());
                this.logger.info("\u53bb\u6389\u76d0\u503c\uff1a" + decryptFirst.substring(0, decryptFirst.length() - userInfo.getSalt().length()));
                String decryptSecond = this.encryptUtils.decryptByType(decryptFirst.substring(0, decryptFirst.length() - userInfo.getSalt().length()), "SM2");
                this.logger.info("\u7b2c\u4e8c\u6b21\u89e3\u5bc6\uff1adecryptSecond = {},password = {}", (Object)decryptSecond, (Object)password);
                if (userInfo.getPassword() != null && decryptSecond.equals(password)) {
                    this.logger.info("\u5339\u914d\u6210\u529f", (Object)decryptSecond, (Object)password);
                    return userInfo;
                }
            } else {
                String inputPwd = this.encryptUtils.encryptByType(password, this.encryptType);
                this.logger.info("\u7b2c\u4e00\u6b21\u52a0\u5bc6\uff1a" + inputPwd);
                this.logger.debug("\u83b7\u53d6\u52a0\u5bc6\u76d0\uff1a" + userInfo.getSalt());
                String salt = userInfo.getSalt();
                this.logger.debug("inputPwd + salt\uff1a" + inputPwd + salt);
                String digPwd = inputPwd + salt;
                this.logger.debug("digPwd:" + digPwd);
                String encrypt = this.encryptUtils.encryptByType(digPwd, this.encryptType);
                this.logger.info("\u7b2c\u4e8c\u6b21\u52a0\u5bc6\uff1a" + encrypt);
                if (userInfo.getPassword() != null && encrypt.equals(userInfo.getPassword())) {
                    return userInfo;
                }
            }
        }
        return null;
    }

    public SelectUserByLoginNameRspBO selectUserByLoginNameNoAuth(SelectUserByLoginNameReqBO selectUserByLoginNameReqBO) {
        this.logger.info("\u767b\u5f55\u5339\u914d\u7528\u6237\u540d\u5165\u53c2\uff1a" + selectUserByLoginNameReqBO.toString());
        if (StringUtils.isBlank((CharSequence)selectUserByLoginNameReqBO.getUsername())) {
            return null;
        }
        String loginName = selectUserByLoginNameReqBO.getUsername();
        return this.userMapper.selectUserByLoginNameNoAuth(loginName);
    }
}

