/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.user.bo.UserIdBO;
import com.ohaotian.authority.user.service.StopUserStatusByUserIdService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP", serviceInterface=StopUserStatusByUserIdService.class)
public class StopUserStatusByUserIdServiceImpl
implements StopUserStatusByUserIdService {
    private static final Logger log = LoggerFactory.getLogger(StopUserStatusByUserIdServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private AuthDistributeMapper authDistributeMapper;
    @Resource(name="dataSend")
    private ProxyMessageProducer dataSend;
    @Value(value="${mq.authority.datasend.topic}")
    private String dataSendTopic;

    @Transactional
    public int stopUserStatusByUserId(UserIdBO userIdBO) {
        if (userIdBO.getUserId() == null) {
            throw new ZTBusinessException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int result = this.userMapper.updateStopUserByUserId(userIdBO);
        UserPO userPO = this.userMapper.selectUserInfo(userIdBO.getUserId());
        if ("auth:org:manage".equals(userPO.getType())) {
            this.organizationMapper.updateMuserIdNull(userIdBO.getUserId());
            this.userMapper.updateTypeByUserId(userIdBO.getUserId(), "auth:default:manage");
            this.authDistributeMapper.deleteRoleByUserIdAndRole(userIdBO.getUserId(), 5L);
        }
        ProxyMessage proxyMessage = new ProxyMessage(this.dataSendTopic, "stop_" + Constants.MQ_DATA_SEND_TAG_USER + "_" + userPO.getTenantId(), userIdBO.getUserId() + "");
        this.dataSend.send(proxyMessage);
        return result;
    }
}

