/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.web.impl.station;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.dao.StationConfigMapper;
import com.ohaotian.authority.dao.StationMapper;
import com.ohaotian.authority.station.bo.SelectStationByBusiReqBO;
import com.ohaotian.authority.station.bo.SelectStationByOrgIdWebReqBO;
import com.ohaotian.authority.station.bo.SelectStationByOrgIdWebRspBO;
import com.ohaotian.authority.station.bo.StationWebBO;
import com.ohaotian.authority.station.service.SelectStationByOrgIdWebService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP", serviceInterface=SelectStationByOrgIdWebService.class)
public class SelectStationByOrgIdWebServiceImpl
implements SelectStationByOrgIdWebService {
    private static final Logger log = LoggerFactory.getLogger(SelectStationByOrgIdWebServiceImpl.class);
    @Autowired
    private StationMapper stationMapper;
    @Autowired
    private StationConfigMapper stationConfigMapper;

    public SelectStationByOrgIdWebRspBO stationList(SelectStationByOrgIdWebReqBO reqBO) {
        SelectStationByOrgIdWebRspBO rspBO = new SelectStationByOrgIdWebRspBO();
        List<StationWebBO> stationList = this.stationMapper.selectStationByOrgId(reqBO.getOrgIdReq());
        if (stationList != null) {
            rspBO.setStationList(stationList);
        }
        if (reqBO.getBusiCode() == null) {
            return rspBO;
        }
        if (stationList != null && stationList.size() > 0) {
            SelectStationByBusiReqBO req = new SelectStationByBusiReqBO();
            req.setBusiCode(reqBO.getBusiCode());
            List<String> stationCodes = this.stationConfigMapper.selectStationByBusi(req);
            SelectStationByOrgIdWebRspBO stationByOrgIdWebRspBO = new SelectStationByOrgIdWebRspBO();
            ArrayList<StationWebBO> list = new ArrayList<StationWebBO>();
            for (String stationCode : stationCodes) {
                StationWebBO stationWebBO = this.stationMapper.selectStationBybuiscodeAndOrgId(stationCode, reqBO.getOrgIdReq());
                if (stationWebBO == null) continue;
                list.add(stationWebBO);
            }
            stationByOrgIdWebRspBO.setStationList(list);
            return stationByOrgIdWebRspBO;
        }
        return null;
    }
}

