/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.web.impl.station;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.StationMapper;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.authority.station.bo.SelectUserByStationCodeReqBO;
import com.ohaotian.authority.station.bo.SelectUserByStationWebReqBO;
import com.ohaotian.authority.station.bo.SelectUserByStationWebRspBO;
import com.ohaotian.authority.station.service.SelectUserByStationWebService;
import com.ohaotian.authority.user.bo.SelectUserInfoWebRspBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP", serviceInterface=SelectUserByStationWebService.class)
public class SelectUserByStationWebServiceImpl
implements SelectUserByStationWebService {
    private static final Logger log = LoggerFactory.getLogger(SelectUserByStationWebServiceImpl.class);
    @Autowired
    private StationMapper stationMapper;
    @Autowired
    private OrganizationMapper organizationMapper;

    public SelectUserByStationWebRspBO selectUserByStation(SelectUserByStationWebReqBO userByStationWebReqBO) {
        List<SelectUserInfoWebRspBO> selectUserInfoWebRspBOS = this.stationMapper.selectUserByStation(userByStationWebReqBO);
        SelectUserByStationWebRspBO stationWebRspBO = new SelectUserByStationWebRspBO();
        stationWebRspBO.setStationUsers(selectUserInfoWebRspBOS);
        return stationWebRspBO;
    }

    public SelectUserByStationWebRspBO selectUserByStationParentOrg(SelectUserByStationWebReqBO reqBO) {
        OrganisationPO organisationPO = this.organizationMapper.selectOrganisationByOrgId(reqBO.getOrgIdWeb());
        if (organisationPO != null) {
            String orgTreepath = organisationPO.getOrgTreePath();
            String[] orgIdStr = orgTreepath.split("-");
            ArrayList<Long> orgIds = new ArrayList<Long>();
            for (String orgId : orgIdStr) {
                if (StringUtils.isBlank((CharSequence)orgId) || orgId.equals("1")) continue;
                orgIds.add(Long.parseLong(orgId));
            }
            SelectUserByStationCodeReqBO condition = new SelectUserByStationCodeReqBO();
            if (!CollectionUtils.isEmpty(orgIds)) {
                condition.setOrgIds(orgIds);
            }
            condition.setStationIds(reqBO.getStationIds());
            condition.setStationCode(reqBO.getStationCode());
            condition.setStationId(reqBO.getStationId());
            List<SelectUserInfoWebRspBO> selectUserInfoWebRspBOS = this.stationMapper.selectUserByStationOrgPath(condition);
            HashMap<String, Object> record = new HashMap<String, Object>(8);
            record.put("parentId", organisationPO.getParentId());
            record.put("status", 0);
            List<OrganisationPO> organisationPOS = this.organizationMapper.selectByCondintion(record);
            if (!CollectionUtils.isEmpty(organisationPOS)) {
                ArrayList floorOrgIds = new ArrayList();
                organisationPOS.stream().forEach(orgPO -> floorOrgIds.add(orgPO.getOrgId()));
                condition.setOrgIds(null);
                condition.setFloorOrgIds(floorOrgIds);
                List<SelectUserInfoWebRspBO> floorUserInfos = this.stationMapper.selectUserByStationOrgPath(condition);
                if (!CollectionUtils.isEmpty(floorUserInfos)) {
                    selectUserInfoWebRspBOS.addAll(floorUserInfos);
                }
            }
            SelectUserByStationWebRspBO rspBO = new SelectUserByStationWebRspBO();
            rspBO.setStationUsers(selectUserInfoWebRspBOS);
            return rspBO;
        }
        throw new ZTBusinessException("\u6ca1\u6709\u76f8\u5173\u673a\u6784" + reqBO.getOrgIdWeb());
    }
}

