/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.station;

import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.role.bo.HasUserListBO;
import com.ohaotian.authority.role.bo.UserBO;
import com.ohaotian.authority.station.bo.SelectStationAlreadyAndNorUserReqBO;
import com.ohaotian.authority.station.service.SelectAllUserByStationIdService;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.station.service.SelectAllUserByStationIdService"})
public class SelectAllUserByStationIdServiceImpl
implements SelectAllUserByStationIdService {
    private static final Logger log = LoggerFactory.getLogger(SelectAllUserByStationIdServiceImpl.class);
    @Autowired
    private UserMapper userMapper;

    @PostMapping(value={"selectAllUserByStationId"})
    public HasUserListBO selectAllUserByStationId(@RequestBody SelectStationAlreadyAndNorUserReqBO reqBO) {
        List<Object> userBOS = new ArrayList();
        if (!StringUtils.isBlank((CharSequence)reqBO.getLoginName())) {
            Page page = new Page(-1, -1);
            userBOS = this.userMapper.selectUserByOrgIdAndLoginName(reqBO.getOrgId(), reqBO.getLoginName(), (Page<UserBO>)page);
        } else {
            userBOS = this.userMapper.selectUserByOrgId(reqBO.getOrgId());
        }
        HasUserListBO userListBO = new HasUserListBO();
        userListBO.setAllUser(userBOS);
        return userListBO;
    }

    @PostMapping(value={"selectAllUserByStationIdAndName"})
    public HasUserListBO selectAllUserByStationIdAndName(@RequestBody SelectStationAlreadyAndNorUserReqBO reqBO) {
        HasUserListBO hasUserListBO = new HasUserListBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<UserBO> userBOS = this.userMapper.selectUserByOrgIdAndLoginName(reqBO.getOrgId(), reqBO.getLoginName(), (Page<UserBO>)page);
        HasUserListBO userListBO = new HasUserListBO();
        userListBO.setPageNo(page.getPageNo());
        userListBO.setTotal(page.getTotalPages());
        userListBO.setRecordsTotal(page.getTotalCount());
        userListBO.setAllUser(userBOS);
        return userListBO;
    }
}

