/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.organisation;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.service.CreateOrganisationService;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.organisation.service.CreateOrganisationService"})
public class CreateOrganisationServiceImpl
implements CreateOrganisationService {
    private static final Logger log = LoggerFactory.getLogger(CreateOrganisationServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(CreateOrganisationServiceImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;
    @Resource(name="dataSend")
    private ProxyMessageProducer dataSend;
    @Value(value="${mq.authority.datasend.topic}")
    private String dataSendTopic;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"createOrganisation"})
    public Long createOrganisation(@RequestBody OrganisationBO organisationBO) {
        List<OrganisationPO> existOrgCode;
        if (organisationBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u7ec4\u7ec7\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (organisationBO.getOrganisationId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u7ec4\u7ec7\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (organisationBO.getParentId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u7ec4\u7ec7\u673a\u6784parentId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.debug("[\u5165\u53c2organisationBO]={}", (Object)organisationBO);
        if (!"org_type_5".equals(organisationBO.getType())) {
            HashMap<String, Object> record = new HashMap<String, Object>();
            record.put("parentId", organisationBO.getParentId());
            record.put("title", organisationBO.getTitle());
            record.put("typeNotEqual", "org_type_5");
            List<OrganisationPO> organisationPOS = this.organizationMapper.selectByCondintion(record);
            if (organisationPOS != null && organisationPOS.size() > 0) {
                throw new ZTBusinessException("\u76f8\u540c\u7236\u7ea7\u8282\u70b9\u4e0b\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
            }
        }
        organisationBO.setCreatUserId(organisationBO.getCreateUserId());
        OrganisationPO dbPOrganisationPO = null;
        Integer deep = 0;
        if (organisationBO.getDeep() == null) {
            Long parentId = organisationBO.getParentId();
            dbPOrganisationPO = this.organizationMapper.selectOrganisationByOrgId(parentId);
            deep = dbPOrganisationPO.getDeep();
        }
        organisationBO.setExtJson(organisationBO.mapToJsaon());
        OrganisationPO organisationPO = new OrganisationPO();
        if (organisationBO != null) {
            BeanUtils.copyProperties((Object)organisationBO, (Object)organisationPO);
        }
        organisationPO.setOrgId(organisationBO.getOrganisationId());
        organisationPO.setDeep(deep + 1);
        organisationPO.setStatus(0);
        String orgCode = organisationPO.getAutoCode();
        if (StringUtils.isNotEmpty((CharSequence)orgCode) && (existOrgCode = this.organizationMapper.isExistOrgCode(organisationPO.getTenantId(), orgCode)).size() > 0) {
            throw new ZTBusinessException("\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        String orgTreePath = dbPOrganisationPO.getOrgTreePath();
        String newOrgTreePath = orgTreePath + organisationBO.getOrganisationId() + "-";
        organisationPO.setOrgTreePath(newOrgTreePath);
        organisationPO.setAutoCode(orgCode);
        this.organizationMapper.insertOrganisation(organisationPO);
        logger.debug("createOrganisation() \u521b\u5efa\u7ec4\u7ec7\u673a\u6784\u6210\u529f");
        ProxyMessage proxyMessage = new ProxyMessage(this.dataSendTopic, "add_" + Constants.MQ_DATA_SEND_TAG_ORGANISATION + "_" + organisationPO.getTenantId(), organisationPO.getOrgId() + "");
        this.dataSend.send(proxyMessage);
        return organisationPO.getOrgId();
    }
}

