/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.organisation;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.bo.OrganisationTitleUpdateReqBO;
import com.ohaotian.authority.organisation.bo.OrganisationTitleUpdateRspBO;
import com.ohaotian.authority.organisation.service.UpdateOrganisationService;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.organisation.service.UpdateOrganisationService"})
public class UpdateOrganisationServiceImpl
implements UpdateOrganisationService {
    private static final Logger log = LoggerFactory.getLogger(UpdateOrganisationServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(UpdateOrganisationServiceImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;
    @Resource(name="dataSend")
    private ProxyMessageProducer dataSend;
    @Value(value="${mq.authority.datasend.topic}")
    private String dataSendTopic;

    @Transactional
    @PostMapping(value={"updateOrganisation"})
    public void updateOrganisation(@RequestBody OrganisationBO organisationBO) {
        if (organisationBO.getOrganisationId() == null) {
            throw new ZTBusinessException("\u5165\u53c2organisationId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.debug("[\u5165\u53c2organisationBO]={}", (Object)organisationBO);
        OrganisationPO organisation = this.organizationMapper.selectOrganisationByOrgId(organisationBO.getOrganisationId());
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("parentId", organisation.getParentId());
        record.put("title", organisationBO.getTitle());
        record.put("authId", organisationBO.getOrganisationId());
        List<OrganisationPO> organisationPOS = this.organizationMapper.selectByCondintion(record);
        if (organisationPOS != null && organisationPOS.size() > 0) {
            organisationPOS.forEach(po -> {
                if (!po.getOrgId().equals(organisationBO.getOrganisationId())) {
                    throw new ZTBusinessException("\u76f8\u540c\u7236\u7ea7\u8282\u70b9\u4e0b\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
                }
            });
        }
        if (StringUtils.isNotEmpty((CharSequence)organisationBO.getAutoCode())) {
            List<OrganisationPO> existOrgCode = this.organizationMapper.isExistOrgCode(organisationBO.getTenantId(), organisationBO.getAutoCode());
            for (OrganisationPO orgCode : existOrgCode) {
                if (orgCode.getOrgId().equals(organisationBO.getOrganisationId())) continue;
                throw new ZTBusinessException("\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
            }
        }
        organisationBO.setExtJson(organisationBO.mapToJsaon());
        OrganisationPO organisationPO = new OrganisationPO();
        if (organisationBO != null) {
            BeanUtils.copyProperties((Object)organisationBO, (Object)organisationPO);
        }
        organisationPO.setOrgId(organisationBO.getOrganisationId());
        this.organizationMapper.updateOrganisation(organisationPO);
        ProxyMessage proxyMessage = new ProxyMessage(this.dataSendTopic, "modify_" + Constants.MQ_DATA_SEND_TAG_ORGANISATION + "_" + organisationBO.getTenantId(), organisationBO.getOrganisationId() + "");
        this.dataSend.send(proxyMessage);
    }

    @PostMapping(value={"updateOrganisationTitle"})
    public OrganisationTitleUpdateRspBO updateOrganisationTitle(@RequestBody OrganisationTitleUpdateReqBO reqBo) {
        if (reqBo.getOrganisationId() == null) {
            throw new ZTBusinessException("\u5165\u53c2organisationId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTitle() == null || reqBo.getTitle().trim().equals("")) {
            throw new ZTBusinessException("\u5165\u53c2title\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.debug("[\u5165\u53c2reqBo]={}", (Object)JSON.toJSONString((Object)reqBo));
        OrganisationPO organisation = this.organizationMapper.selectOrganisationByOrgId(reqBo.getOrganisationId());
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("parentId", organisation.getParentId());
        record.put("title", reqBo.getTitle());
        record.put("authId", reqBo.getOrganisationId());
        List<OrganisationPO> organisationPOS = this.organizationMapper.selectByCondintion(record);
        if (organisationPOS != null && organisationPOS.size() > 0) {
            organisationPOS.forEach(po -> {
                if (!po.getOrgId().equals(reqBo.getOrganisationId())) {
                    throw new ZTBusinessException("\u76f8\u540c\u7236\u7ea7\u8282\u70b9\u4e0b\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
                }
            });
        }
        OrganisationPO organisationPo = new OrganisationPO();
        organisationPo.setOrgId(reqBo.getOrganisationId());
        organisationPo.setTitle(reqBo.getTitle());
        this.organizationMapper.updateOrganisation(organisationPo);
        ProxyMessage proxyMessage = new ProxyMessage(this.dataSendTopic, "modify_" + Constants.MQ_DATA_SEND_TAG_ORGANISATION + "_" + organisation.getTenantId(), organisation.getOrgId() + "");
        this.dataSend.send(proxyMessage);
        OrganisationTitleUpdateRspBO rspBo = new OrganisationTitleUpdateRspBO();
        rspBo.setOrganisationId(reqBo.getOrganisationId());
        rspBo.setCode("0");
        rspBo.setMessage("\u673a\u6784\u540d\u79f0\u66f4\u65b0\u6210\u529f");
        return rspBo;
    }
}

