/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.user.bo.QryVerifyCodePictureReqBO;
import com.ohaotian.authority.user.bo.QryVerifyCodePictureRspBO;
import com.ohaotian.authority.user.service.QryVerifyCodePictureService;
import com.ohaotian.authority.util.VerifyCodeUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.user.service.QryVerifyCodePictureService"})
public class QryVerifyCodePictureServiceImpl
implements QryVerifyCodePictureService {
    private static final Logger log = LoggerFactory.getLogger(QryVerifyCodePictureServiceImpl.class);
    private static Integer codeSize = 4;
    private Base64 base64 = new Base64();
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${picVfCodeExpTime:300}")
    private int picVfCodeExpTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"getPicVfCode"})
    public QryVerifyCodePictureRspBO getPicVfCode(@RequestBody QryVerifyCodePictureReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u56fe\u7247\u9a8c\u8bc1\u7801\u5165\u53c2:{}", (Object)reqBO);
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getIp())) {
            throw new ZTBusinessException("\u5165\u53c2[ip]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QryVerifyCodePictureRspBO rspBO = new QryVerifyCodePictureRspBO();
        String code = VerifyCodeUtils.generateVerifyCode(codeSize);
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u56fe\u7247\u9a8c\u8bc1\u7801:{}", (Object)code);
        }
        int w = 80;
        int h = 30;
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        try {
            Object obj = this.cacheClient.get(reqBO.getIp());
            if (null != obj) {
                Object objCode = this.cacheClient.get(String.valueOf(obj) + "_" + reqBO.getIp());
                if (null != objCode) {
                    this.cacheClient.delete(String.valueOf(obj) + "_" + reqBO.getIp());
                }
                this.cacheClient.delete(reqBO.getIp());
            }
            VerifyCodeUtils.outputImage(w, h, fos, code);
            String picVfCode = this.base64.encodeToString(fos.toByteArray());
            rspBO.setPicVfCode(code);
            this.cacheClient.set(reqBO.getIp(), (Object)code, this.picVfCodeExpTime);
            this.cacheClient.set(code + "_" + reqBO.getIp(), (Object)code, this.picVfCodeExpTime);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rspBO;
    }
}

