/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.opsrole;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.MenuMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.opsrole.AuthOpsSyncRoleResBusiService;
import com.ohaotian.authority.opsrole.bo.AuthOpsSyncRoleResBatchBusiReqBo;
import com.ohaotian.authority.opsrole.bo.AuthOpsSyncRoleResBatchBusiRspBo;
import com.ohaotian.authority.opsrole.bo.AuthOpsSyncRoleResBo;
import com.ohaotian.authority.opsrole.bo.AuthOpsSyncRoleResBusiReqBo;
import com.ohaotian.authority.opsrole.bo.AuthOpsSyncRoleResBusiRspBo;
import com.ohaotian.authority.po.Menu;
import com.ohaotian.authority.po.Role;
import com.ohaotian.authority.po.RoleAutoPO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.opsrole.AuthOpsSyncRoleResBusiService"})
public class AuthOpsSyncRoleResBusiServiceImpl
implements AuthOpsSyncRoleResBusiService {
    private static final Logger log = LoggerFactory.getLogger(AuthOpsSyncRoleResBusiServiceImpl.class);
    @Resource
    private MenuMapper menuMapper;
    @Resource
    private RoleMapper roleMapper;

    @Deprecated
    @Transactional
    @PostMapping(value={"dealSyncRoleResOps"})
    public AuthOpsSyncRoleResBusiRspBo dealSyncRoleResOps(@RequestBody AuthOpsSyncRoleResBusiReqBo reqBo) {
        List<String> errorMsg = this.parameterValidation(reqBo);
        if (!errorMsg.isEmpty()) {
            throw new ZTBusinessException("\u89d2\u8272\u8d44\u6e90\u540c\u6b65\u5931\u8d25:" + String.join((CharSequence)";", errorMsg));
        }
        if (Constants.OPS_C.equals(reqBo.getOpeType())) {
            Menu menu = this.menuMapper.selectByPrimaryKey(reqBo.getOpsMenuId());
            if (menu == null) {
                throw new ZTBusinessException("\u89d2\u8272\u8d44\u6e90\u540c\u6b65\u5931\u8d25:\u6839\u636e\u83dc\u5355ID\u67e5\u8be2\u4e3a\u7a7a");
            }
            Long authId = Sequence.getInstance().nextId();
            this.roleMapper.saveRoleAuto(authId, reqBo.getOpsRoleId(), reqBo.getOpsMenuId());
        } else if (Constants.OPS_D.equals(reqBo.getOpeType())) {
            this.roleMapper.deleteRoleAuto(reqBo.getOpsRoleId(), reqBo.getOpsMenuId());
        }
        AuthOpsSyncRoleResBusiRspBo rspBo = new AuthOpsSyncRoleResBusiRspBo();
        rspBo.setCode("0");
        rspBo.setMessage("\u89d2\u8272\u8d44\u6e90\u540c\u6b65\u6210\u529f");
        return rspBo;
    }

    @Transactional
    @PostMapping(value={"dealSyncRoleResOpsBatch"})
    public AuthOpsSyncRoleResBatchBusiRspBo dealSyncRoleResOpsBatch(@RequestBody AuthOpsSyncRoleResBatchBusiReqBo reqBo) {
        List<String> errorMsg = this.parameterValidation(reqBo);
        if (!CollectionUtils.isEmpty(errorMsg)) {
            throw new ZTBusinessException("\u89d2\u8272\u8d44\u6e90\u6279\u91cf\u540c\u6b65\u5931\u8d25:" + String.join((CharSequence)";", errorMsg));
        }
        List<String> roleCodeList = reqBo.getRoleResList().stream().map(AuthOpsSyncRoleResBo::getOpsRoleCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> menuIdList = reqBo.getRoleResList().stream().map(AuthOpsSyncRoleResBo::getOpsMenuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(roleCodeList)) {
            throw new ZTBusinessException("\u89d2\u8272\u8d44\u6e90\u6279\u91cf\u540c\u6b65\u5931\u8d25:\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(menuIdList)) {
            throw new ZTBusinessException("\u89d2\u8272\u8d44\u6e90\u6279\u91cf\u540c\u6b65\u5931\u8d25:\u83dc\u5355ID\u4e3a\u7a7a");
        }
        Map<String, Long> mapRoleCodeAndId = this.mapRole(roleCodeList);
        Map<Long, Menu> mapMenuAndParent = this.mapMenuAndParent(menuIdList);
        HashMap<Long, Set<Long>> mapRoleMenu = new HashMap<Long, Set<Long>>();
        for (AuthOpsSyncRoleResBo bo : reqBo.getRoleResList()) {
            Long roleId = mapRoleCodeAndId.get(bo.getOpsRoleCode());
            if (roleId == null) {
                errorMsg.add("\u89d2\u8272\u7f16\u7801[" + bo.getOpsRoleCode() + "]\u67e5\u8be2\u89d2\u8272ID\u4e3a\u7a7a");
                continue;
            }
            if (!mapRoleMenu.containsKey(roleId)) {
                mapRoleMenu.put(roleId, new HashSet());
            }
            ((Set)mapRoleMenu.get(roleId)).add(bo.getOpsMenuId());
        }
        if (!CollectionUtils.isEmpty(errorMsg)) {
            throw new ZTBusinessException("\u89d2\u8272\u8d44\u6e90\u6279\u91cf\u540c\u6b65\u5931\u8d25:" + String.join((CharSequence)";", errorMsg));
        }
        if (Constants.OPS_C.equals(reqBo.getOpeType())) {
            return this.dealRoleMenuAdd(mapRoleMenu, mapMenuAndParent);
        }
        if (Constants.OPS_D.equals(reqBo.getOpeType())) {
            return this.dealRoleMenuDelete(mapRoleMenu, mapMenuAndParent);
        }
        throw new ZTBusinessException("\u89d2\u8272\u8d44\u6e90\u6279\u91cf\u540c\u6b65\u5931\u8d25:\u64cd\u4f5c\u7c7b\u578b[opeType]\u9519\u8bef");
    }

    private Map<Long, Menu> mapMenuAndParent(List<Long> menuIdList) {
        HashMap<Long, Menu> allMenu = new HashMap<Long, Menu>();
        ArrayList<String> errorMsg = new ArrayList<String>();
        for (Long menuId : menuIdList) {
            Menu menu = (Menu)allMenu.get(menuId);
            if (menu != null) continue;
            menu = this.menuMapper.selectByPrimaryKey(menuId);
            if (menu == null) {
                errorMsg.add("\u83dc\u5355[" + menuId + "]\u4e0d\u5b58\u5728");
                continue;
            }
            if (menu.getMenuId() == null || menu.getParentId() == null || menu.getDeep() == null || StringUtils.isBlank((CharSequence)menu.getType())) {
                errorMsg.add("\u83dc\u5355[" + menuId + "]\u6216parentId[" + menu.getParentId() + "]\u6216deep[" + menu.getDeep() + "]\u6216type[" + menu.getType() + "]\u5b58\u5728\u4e3a\u7a7a");
                continue;
            }
            if (Arrays.asList("C", "M").contains(menu.getType()) && menu.getDeep() != 3) {
                errorMsg.add("\u89d2\u8272\u7ed1\u5b9a\u89e3\u7ed1\u83dc\u5355[" + menuId + "]\uff0cdeep[" + menu.getDeep() + "]\u53ea\u80fd\u4e3a3");
                continue;
            }
            allMenu.put(menuId, (Menu)JSON.parseObject((String)JSON.toJSONString((Object)menu), Menu.class));
            Long parenMenuId = menu.getParentId();
            int count = 0;
            while (parenMenuId != null && 0L != parenMenuId && count++ < 10) {
                menu = (Menu)allMenu.get(parenMenuId);
                if (menu != null) continue;
                menu = this.menuMapper.selectByPrimaryKey(parenMenuId);
                if (menu == null) {
                    parenMenuId = null;
                    continue;
                }
                allMenu.put(parenMenuId, (Menu)JSON.parseObject((String)JSON.toJSONString((Object)menu), Menu.class));
                parenMenuId = menu.getParentId();
            }
        }
        if (!CollectionUtils.isEmpty(errorMsg)) {
            throw new ZTBusinessException("\u89d2\u8272\u8d44\u6e90\u6279\u91cf\u540c\u6b65\u5931\u8d25:\u83dc\u5355" + errorMsg + "\u4e0d\u5b58\u5728");
        }
        return allMenu;
    }

    private AuthOpsSyncRoleResBatchBusiRspBo dealRoleMenuDelete(Map<Long, Set<Long>> mapRoleMenu, Map<Long, Menu> mapMenuAndParent) {
        ArrayList<String> errorMsg = new ArrayList<String>();
        HashMap mapRoleMenuDel = new HashMap();
        for (Map.Entry<Long, Set<Long>> entry : mapRoleMenu.entrySet()) {
            Long roleId = entry.getKey();
            Set<Long> menuIdList = entry.getValue();
            ArrayList<Long> existMenuIdList = new ArrayList<Long>(this.menuMapper.selectRoleMenuIds(roleId));
            for (Long menuId : menuIdList) {
                Menu level3Menu;
                HashSet<Long> delMenuIdSet = new HashSet<Long>();
                if (!CollectionUtils.isEmpty(existMenuIdList) && existMenuIdList.contains(menuId)) {
                    delMenuIdSet.add(menuId);
                }
                if ((level3Menu = mapMenuAndParent.get(menuId)) == null) {
                    errorMsg.add("\u83dc\u5355[" + menuId + "]\u4e0d\u5b58\u5728");
                    continue;
                }
                if (level3Menu.getParentId() == null || level3Menu.getDeep() == null || StringUtils.isBlank((CharSequence)level3Menu.getType())) {
                    errorMsg.add("\u83dc\u5355[" + menuId + "]parentId[" + level3Menu.getParentId() + "]\u6216deep[" + level3Menu.getDeep() + "]\u6216type[" + level3Menu.getType() + "]\u5b58\u5728\u4e3a\u7a7a");
                    continue;
                }
                if ("F".equals(level3Menu.getType())) {
                    delMenuIdSet.add(menuId);
                } else {
                    if (3 != level3Menu.getDeep()) {
                        errorMsg.add("\u83dc\u5355[" + menuId + "]deep\u4e0d\u4e3a\u7b2c\u4e09\u7ea7");
                        continue;
                    }
                    Menu level2Menu = mapMenuAndParent.get(level3Menu.getParentId());
                    if (level2Menu == null) {
                        errorMsg.add("\u83dc\u5355[" + menuId + "]\u67e5\u8be2\u4e8c\u7ea7\u83dc\u5355[" + level3Menu.getParentId() + "]\u4e3a\u7a7a");
                    } else if (!Arrays.asList("C", "M").contains(level2Menu.getType())) {
                        errorMsg.add("\u83dc\u5355[" + menuId + "]\u7684\u4e8c\u7ea7\u7ea7\u83dc\u5355[" + level2Menu.getMenuId() + "]\u7c7b\u578btype[" + level2Menu.getType() + "]\u4e0d\u662f\u83dc\u5355\u6216\u76ee\u5f55");
                    } else if (level2Menu.getMenuId() == null || level2Menu.getParentId() == null) {
                        errorMsg.add("\u83dc\u5355[" + menuId + "]\u7684\u4e8c\u7ea7\u7ea7\u83dc\u5355ID[" + level2Menu.getMenuId() + "]\u6216parentId[" + level2Menu.getParentId() + "]\u4e3a\u7a7a");
                    } else if (!CollectionUtils.isEmpty(existMenuIdList) && existMenuIdList.contains(level2Menu.getMenuId())) {
                        List<Menu> level2MenuList = this.menuMapper.selectByParentId(level3Menu.getParentId());
                        if (!CollectionUtils.isEmpty(level2MenuList) && level2MenuList.stream().anyMatch(i -> !Objects.equals(i.getMenuId(), level3Menu.getParentId()))) {
                            log.info("er\u7ea7\u83dc\u5355[{}]\u5b58\u5728\u5176\u4ed6\u83dc\u5355", (Object)level3Menu.getParentId());
                        } else {
                            delMenuIdSet.add(level2Menu.getMenuId());
                            Menu level1Menu = mapMenuAndParent.get(level2Menu.getParentId());
                            if (level1Menu == null) {
                                errorMsg.add("\u83dc\u5355[" + menuId + "]\u67e5\u8be2\u4e00\u7ea7\u83dc\u5355[" + level2Menu.getParentId() + "]\u4e3a\u7a7a");
                            } else if (!Arrays.asList("C", "M").contains(level1Menu.getType())) {
                                errorMsg.add("\u83dc\u5355[" + menuId + "]\u7684\u4e00\u7ea7\u7ea7\u83dc\u5355[" + level1Menu.getMenuId() + "]\u7c7b\u578btype[" + level1Menu.getType() + "]\u4e0d\u662f\u83dc\u5355\u6216\u76ee\u5f55");
                            } else if (!CollectionUtils.isEmpty(existMenuIdList) && existMenuIdList.contains(level2Menu.getParentId())) {
                                List<Menu> level1MenuList = this.menuMapper.selectByParentId(level2Menu.getParentId());
                                if (!CollectionUtils.isEmpty(level1MenuList) && level1MenuList.stream().anyMatch(i -> !Objects.equals(i.getMenuId(), level2Menu.getParentId()))) {
                                    log.info("\u4e00\u7ea7\u83dc\u5355[{}]\u5b58\u5728\u5176\u4ed6\u83dc\u5355", (Object)level2Menu.getParentId());
                                } else {
                                    delMenuIdSet.add(level2Menu.getMenuId());
                                }
                            }
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(errorMsg)) {
                    throw new ZTBusinessException("\u89d2\u8272\u8d44\u6e90\u6279\u91cf\u540c\u6b65\u5220\u9664:" + String.join((CharSequence)";", errorMsg));
                }
                log.error("\u89e3\u7ed1\u89d2\u8272\u83dc\u5355-roleId:{}.menuIdList:{}.addMenuIdSet:{}", new Object[]{roleId, menuIdList, delMenuIdSet});
                for (Long delMenuId : delMenuIdSet) {
                    RoleAutoPO roleAutoPo = this.roleMapper.selectRoleAutoByRoleAndMenu(roleId, delMenuId);
                    if (roleAutoPo == null) continue;
                    this.roleMapper.deleteRoleAuto(roleId, delMenuId);
                }
                if (!mapRoleMenuDel.containsKey(roleId)) {
                    mapRoleMenuDel.put(roleId, new ArrayList());
                }
                ((List)mapRoleMenuDel.get(roleId)).addAll(delMenuIdSet);
            }
        }
        AuthOpsSyncRoleResBatchBusiRspBo rspBo = new AuthOpsSyncRoleResBatchBusiRspBo();
        rspBo.setCode("0");
        rspBo.setMessage("\u89d2\u8272\u83dc\u5355\u6279\u91cf\u89e3\u7ed1\u6210\u529f");
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u89d2\u8272\u83dc\u5355\u6279\u91cf\u89e3\u7ed1\u6210\u529f");
        rspBo.setMapDel(mapRoleMenuDel);
        return rspBo;
    }

    private AuthOpsSyncRoleResBatchBusiRspBo dealRoleMenuAdd(Map<Long, Set<Long>> mapRoleMenu, Map<Long, Menu> mapMenuAndParent) {
        ArrayList<String> errorMsg = new ArrayList<String>();
        HashMap mapRoleMenuAdd = new HashMap();
        for (Map.Entry<Long, Set<Long>> entry : mapRoleMenu.entrySet()) {
            Long roleId = entry.getKey();
            Set<Long> menuIdList = entry.getValue();
            HashSet<Long> addMenuIdSet = new HashSet<Long>();
            ArrayList<Long> existMenuIdList = new ArrayList<Long>(this.menuMapper.selectRoleMenuIds(roleId));
            for (Long menuId : menuIdList) {
                Menu menuAdd;
                if (CollectionUtils.isEmpty(existMenuIdList) || !existMenuIdList.contains(menuId)) {
                    addMenuIdSet.add(menuId);
                }
                if ((menuAdd = mapMenuAndParent.get(menuId)) == null) {
                    errorMsg.add("\u83dc\u5355[" + menuId + "]\u4e0d\u5b58\u5728");
                    continue;
                }
                Long parentId = menuAdd.getParentId();
                if (parentId == null || menuAdd.getDeep() == null || StringUtils.isBlank((CharSequence)menuAdd.getType())) {
                    errorMsg.add("\u83dc\u5355[" + menuId + "]parentId[" + parentId + "]\u6216deep[" + menuAdd.getDeep() + "]\u6216type[" + menuAdd.getType() + "]\u5b58\u5728\u4e3a\u7a7a");
                    continue;
                }
                if ("F".equals(menuAdd.getType())) {
                    addMenuIdSet.add(menuId);
                    continue;
                }
                if (3 != menuAdd.getDeep()) {
                    errorMsg.add("\u83dc\u5355[" + menuId + "]deep\u4e0d\u4e3a\u7b2c\u4e09\u7ea7");
                    continue;
                }
                Menu menu2 = mapMenuAndParent.get(parentId);
                if (menu2 == null) {
                    errorMsg.add("\u83dc\u5355[" + menuId + "]\u4e0a\u7ea7\u83dc\u5355[" + parentId + "]\u4e0d\u5b58\u5728");
                    continue;
                }
                if (!Arrays.asList("C", "M").contains(menu2.getType())) {
                    errorMsg.add("\u83dc\u5355[" + menuId + "]\u67e5\u8be2\u4e0a\u7ea7\u83dc\u5355[" + parentId + "]\u7c7b\u578btype[" + menu2.getType() + "]\u4e0d\u662f\u83dc\u5355\u6216\u76ee\u5f55");
                    continue;
                }
                if (CollectionUtils.isEmpty(existMenuIdList) || !existMenuIdList.contains(parentId)) {
                    addMenuIdSet.add(parentId);
                }
                if (menu2.getParentId() == null) {
                    errorMsg.add("\u83dc\u5355[" + menuId + "]\u4e0a\u7ea7\u83dc\u5355[" + menuAdd.getParentId() + "]\u7684\u4e0a\u7ea7\u83dc\u5355[" + menu2.getParentId() + "]parentId\u4e3a\u7a7a");
                    continue;
                }
                Menu menu1 = mapMenuAndParent.get(menu2.getParentId());
                if (menu1 == null) {
                    errorMsg.add("\u83dc\u5355[" + menuId + "]\u4e0a\u7ea7\u83dc\u5355[" + menuAdd.getParentId() + "]\u4e0a\u7ea7\u83dc\u5355[" + menu2.getParentId() + "]\u4e0d\u5b58\u5728");
                    continue;
                }
                if (!Arrays.asList("C", "M").contains(menu1.getType())) {
                    errorMsg.add("\u83dc\u5355[" + menuId + "]\u4e0a\u7ea7\u83dc\u5355[" + menuAdd.getParentId() + "]\u4e0a\u7ea7\u83dc\u5355[" + menu2.getParentId() + "]\u7c7b\u578btype[" + menu1.getType() + "]\u4e0d\u662f\u83dc\u5355\u6216\u76ee\u5f55");
                    continue;
                }
                if (!CollectionUtils.isEmpty(existMenuIdList) && existMenuIdList.contains(menu2.getParentId())) continue;
                addMenuIdSet.add(menu2.getParentId());
            }
            if (!CollectionUtils.isEmpty(errorMsg)) {
                throw new ZTBusinessException("\u89d2\u8272\u8d44\u6e90\u6279\u91cf\u540c\u6b65\u7ed1\u5b9a:" + String.join((CharSequence)";", errorMsg));
            }
            log.error("\u7ed1\u5b9a\u89d2\u8272\u83dc\u5355-roleId:{}.menuIdList:{}.addMenuIdSet:{}", new Object[]{roleId, menuIdList, addMenuIdSet});
            for (Long menuId : addMenuIdSet) {
                RoleAutoPO roleAutoPo = this.roleMapper.selectRoleAutoByRoleAndMenu(roleId, menuId);
                if (roleAutoPo != null) continue;
                this.roleMapper.saveRoleAuto(Sequence.getInstance().nextId(), roleId, menuId);
            }
            mapRoleMenuAdd.put(roleId, new ArrayList(addMenuIdSet));
        }
        AuthOpsSyncRoleResBatchBusiRspBo rspBo = new AuthOpsSyncRoleResBatchBusiRspBo();
        rspBo.setCode("0");
        rspBo.setMessage("\u89d2\u8272\u83dc\u5355\u6279\u91cf\u7ed1\u5b9a\u6210\u529f");
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u89d2\u8272\u83dc\u5355\u6279\u91cf\u7ed1\u5b9a\u6210\u529f");
        rspBo.setMapAdd(mapRoleMenuAdd);
        return rspBo;
    }

    private Map<String, Long> mapRole(List<String> roleCodeList) {
        HashMap<String, Long> mapRoleCodeAndId = new HashMap<String, Long>();
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("authIdentityList", new ArrayList<String>(roleCodeList));
        List<Role> roles = this.roleMapper.selectByRecord(record);
        if (!CollectionUtils.isEmpty(roles)) {
            mapRoleCodeAndId.putAll(roles.stream().collect(Collectors.toMap(Role::getAuthIdentity, Role::getRoleId, (c, n) -> c)));
        }
        ArrayList oldRoleCodes = new ArrayList(mapRoleCodeAndId.keySet());
        List notExitRoleCode = roleCodeList.stream().filter(i -> !oldRoleCodes.contains(i)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notExitRoleCode)) {
            throw new ZTBusinessException("\u89d2\u8272\u8d44\u6e90\u6279\u91cf\u540c\u6b65\u5931\u8d25:\u89d2\u8272[" + String.join((CharSequence)";", notExitRoleCode) + "]\u4e0d\u5b58\u5728");
        }
        return mapRoleCodeAndId;
    }

    private List<String> parameterValidation(AuthOpsSyncRoleResBatchBusiReqBo reqBo) {
        ArrayList<String> errorMsg = new ArrayList<String>();
        if (reqBo == null) {
            throw new ZTBusinessException("\u89d2\u8272\u8d44\u6e90\u6279\u91cf\u540c\u6b65\u5931\u8d25:\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOpeType()) || !Arrays.asList(Constants.OPS_C, Constants.OPS_D).contains(reqBo.getOpeType())) {
            errorMsg.add("\u64cd\u4f5c\u7c7b\u578b[opeType]\u9519\u8bef\u6216\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getRoleResList())) {
            errorMsg.add("\u89d2\u8272\u7f16\u7801\u83dc\u5355ID\u96c6\u5408[roleResList]\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            int index = 0;
            ArrayList<String> roleCodeMenuIdKey = new ArrayList<String>();
            for (AuthOpsSyncRoleResBo item : reqBo.getRoleResList()) {
                String key;
                if (StringUtils.isBlank((CharSequence)item.getOpsRoleCode())) {
                    errorMsg.add("\u7b2c" + index + "\u884c\u89d2\u8272\u7f16\u7801[roleResList.opsRoleCode]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (item.getOpsMenuId() == null || item.getOpsMenuId() == 0L) {
                    errorMsg.add("\u7b2c" + index + "\u884c\u83dc\u5355ID[roleResList.opsMenuId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (roleCodeMenuIdKey.contains(key = item.getOpsRoleCode() + "-" + item.getOpsMenuId())) {
                    errorMsg.add("\u7b2c" + index + "\u884c\u89d2\u8272\u7f16\u7801+\u83dc\u5355ID\u91cd\u590d" + key);
                } else {
                    roleCodeMenuIdKey.add(key);
                }
                ++index;
            }
        }
        return errorMsg;
    }

    private List<String> parameterValidation(AuthOpsSyncRoleResBusiReqBo reqBo) {
        ArrayList<String> errorMsg = new ArrayList<String>();
        if (reqBo == null) {
            errorMsg.add("\u5165\u53c2\u4e3a\u7a7a");
            return errorMsg;
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOpeType()) || !Arrays.asList(Constants.OPS_C, Constants.OPS_D).contains(reqBo.getOpeType())) {
            errorMsg.add("\u64cd\u4f5c\u7c7b\u578b[opeType]\u9519\u8bef\u6216\u4e3a\u7a7a");
        }
        if (reqBo.getOpsMenuId() == null || reqBo.getOpsMenuId() == 0L) {
            errorMsg.add("\u83dc\u5355ID[menuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOpsRoleId() == null || reqBo.getOpsRoleId() == 0L) {
            errorMsg.add("\u89d2\u8272ID[roleId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return errorMsg;
    }
}

