/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.role.bo.AuthDistributeBO;
import com.ohaotian.authority.role.service.SaveDistributeBusiService;
import com.ohaotian.authority.user.bo.SaveUserRolesAuthReqBO;
import com.ohaotian.authority.user.service.DeleteRoleByUserIdService;
import com.ohaotian.authority.user.service.SaveUserAuthService;
import com.ohaotian.authority.util.RoleGrantReqUtils;
import com.ohaotian.plugin.db.Sequence;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.user.service.SaveUserAuthService"})
public class SaveUserAuthServiceImpl
implements SaveUserAuthService {
    private static final Logger log = LoggerFactory.getLogger(SaveUserAuthServiceImpl.class);
    @Autowired
    private DeleteRoleByUserIdService deleteRoleByUserIdService;
    @Autowired
    private SaveDistributeBusiService saveDistributeBusiService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"saveUserAuthService"})
    public void saveUserAuthService(@RequestBody SaveUserRolesAuthReqBO saveUserAuthReqBO) {
        Set<Long> delete;
        Long userId = saveUserAuthReqBO.getUserId();
        String json = saveUserAuthReqBO.getJson();
        String manaOrgTreePath = saveUserAuthReqBO.getManaOrgTreePath();
        Map<String, Set<Long>> stringSetMap = RoleGrantReqUtils.otherGrant(json);
        Set<Long> add = stringSetMap.get("add");
        if (add != null && add.size() > 0) {
            add.forEach(e -> {
                AuthDistributeBO authDistributeBO = new AuthDistributeBO();
                Sequence sequence = Sequence.getInstance();
                long l = sequence.nextId();
                authDistributeBO.setAuthId(Long.valueOf(l));
                authDistributeBO.setUserId(userId);
                authDistributeBO.setRoleId(e);
                authDistributeBO.setDisFlag(Constants.AUTH_USER);
                authDistributeBO.setManaOrgTreePath(manaOrgTreePath);
                this.saveDistributeBusiService.saveDistribute(authDistributeBO);
            });
        }
        if ((delete = stringSetMap.get("delete")) != null && delete.size() > 0) {
            delete.forEach(e -> {
                AuthDistributeBO authDistributeBO = new AuthDistributeBO();
                authDistributeBO.setUserId(userId);
                authDistributeBO.setRoleId(e);
                this.deleteRoleByUserIdService.deleteRoleByUserId(authDistributeBO);
            });
        }
    }
}

