/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.logger;

import com.alibaba.fastjson.JSONArray;
import com.ohaotian.authority.dao.LoginLogMapper;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.logger.bo.LoginLogBO;
import com.ohaotian.authority.logger.bo.SelectLoginLogsPageReqBO;
import com.ohaotian.authority.logger.service.SelectLoginLogsPageBusiService;
import com.ohaotian.authority.po.LoginLog;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.logger.service.SelectLoginLogsPageBusiService"})
public class SelectLoginLogsPageBusiServiceImpl
implements SelectLoginLogsPageBusiService {
    private static final Logger log = LoggerFactory.getLogger(SelectLoginLogsPageBusiServiceImpl.class);
    @Autowired
    LoginLogMapper loginLogMapper;
    @Autowired
    OrganizationMapper organizationMapper;

    @PostMapping(value={"selectLoginLogsPage"})
    public RspPage<LoginLogBO> selectLoginLogsPage(@RequestBody SelectLoginLogsPageReqBO logsPageReqBO) {
        long l1;
        Page page = new Page(logsPageReqBO.getPageNo(), logsPageReqBO.getPageSize());
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("loginName", logsPageReqBO.getLoginName());
        condition.put("startTime", logsPageReqBO.getStartTime());
        condition.put("endTime", logsPageReqBO.getEndTime());
        condition.put("name", logsPageReqBO.getUserName());
        condition.put("title", logsPageReqBO.getTitle());
        condition.put("orgIdWeb", logsPageReqBO.getOrgIdWeb());
        condition.put("host", logsPageReqBO.getHost());
        LinkedList loginLogBOS = new LinkedList();
        log.info("newFlag=====" + logsPageReqBO.getNewFlag());
        if (logsPageReqBO.getNewFlag() == null || !logsPageReqBO.getNewFlag().booleanValue()) {
            l1 = System.currentTimeMillis();
            List<LoginLog> list = this.loginLogMapper.selectLogsByRecord(condition, (Page<Map<String, Object>>)page);
            long l2 = System.currentTimeMillis();
            log.info("time-sql======" + (l2 - l1));
            if (!CollectionUtils.isEmpty(list)) {
                loginLogBOS.addAll(JSONArray.parseArray((String)JSONArray.toJSONString(list), LoginLogBO.class));
                loginLogBOS.forEach(bo -> {
                    if (bo.getLogId() == 1L) {
                        bo.setOrgFullName(bo.getTitle());
                    }
                });
            }
            long l3 = System.currentTimeMillis();
            log.info("time-data========" + (l3 - l2));
        } else {
            l1 = System.currentTimeMillis();
            List<LoginLog> list = this.loginLogMapper.selectLogsByRecord1(condition, (Page<Map<String, Object>>)page);
            long l2 = System.currentTimeMillis();
            log.info("time-sql======" + (l2 - l1));
            if (!CollectionUtils.isEmpty(list)) {
                Set<Object> orgIds = new HashSet();
                for (LoginLog loginLog : list) {
                    if (!StringUtils.hasText((String)loginLog.getOrgTreePath())) continue;
                    Collections.addAll(orgIds, loginLog.getOrgTreePath().split("-"));
                }
                if (!CollectionUtils.isEmpty(orgIds = orgIds.stream().filter(StringUtils::hasText).collect(Collectors.toSet()))) {
                    List<OrganisationPO> organisationPOList = this.organizationMapper.selectOrgByOrgIds(orgIds.stream().map(Long::valueOf).collect(Collectors.toList()));
                    Map<Long, String> collect = organisationPOList.stream().collect(Collectors.toMap(OrganisationPO::getOrgId, OrganisationPO::getTitle, (a, b) -> a));
                    list.forEach(logPo -> {
                        if (StringUtils.hasText((String)logPo.getOrgTreePath())) {
                            StringJoiner sj = new StringJoiner("-");
                            Arrays.stream(logPo.getOrgTreePath().split("-")).filter(StringUtils::hasText).forEach(str -> {
                                String name = (String)collect.get(Long.valueOf(str));
                                sj.add(name);
                            });
                            logPo.setOrgFullName(sj.toString());
                        }
                    });
                    loginLogBOS.addAll(JSONArray.parseArray((String)JSONArray.toJSONString(list), LoginLogBO.class));
                }
            }
            long l3 = System.currentTimeMillis();
            log.info("time-data========" + (l3 - l2));
        }
        RspPage rsp = new RspPage();
        rsp.setPageNo(logsPageReqBO.getPageNo());
        rsp.setTotal(page.getTotalPages());
        rsp.setRecordsTotal(page.getTotalCount());
        rsp.setRows(loginLogBOS);
        return rsp;
    }
}

