/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.opsrole;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.OrgRoleMapper;
import com.ohaotian.authority.dao.OrgRoleMenuMapper;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.opsrole.AuthOpsSyncRoleBusiService;
import com.ohaotian.authority.opsrole.bo.AuthOpsSyncRoleBatchBo;
import com.ohaotian.authority.opsrole.bo.AuthOpsSyncRoleBatchBusiReqBo;
import com.ohaotian.authority.opsrole.bo.AuthOpsSyncRoleBatchBusiRspBo;
import com.ohaotian.authority.opsrole.bo.AuthOpsSyncRoleBusiReqBo;
import com.ohaotian.authority.opsrole.bo.AuthOpsSyncRoleBusiRspBo;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.authority.po.Role;
import com.ohaotian.authority.role.bo.SelectIdentityRepeatReqBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.opsrole.AuthOpsSyncRoleBusiService"})
public class AuthOpsSyncRoleBusiServiceImpl
implements AuthOpsSyncRoleBusiService {
    private static final Logger log = LoggerFactory.getLogger(AuthOpsSyncRoleBusiServiceImpl.class);
    @Resource
    private RoleMapper roleMapper;
    @Resource
    private OrgRoleMapper orgRoleMapper;
    @Resource
    private OrgRoleMenuMapper orgRoleMenuMapper;
    @Resource
    private OrganizationMapper organizationMapper;

    @Deprecated
    @Transactional
    @PostMapping(value={"dealSyncRoleOps"})
    public AuthOpsSyncRoleBusiRspBo dealSyncRoleOps(@RequestBody AuthOpsSyncRoleBusiReqBo reqBo) {
        throw new ZTBusinessException("\u89d2\u8272\u540c\u6b65\u5931\u8d25:\u5355\u4e2a\u903b\u8f91\u672a\u5b9e\u73b0\uff0c\u8bf7\u81ea\u884c\u5b9e\u73b0");
    }

    @PostMapping(value={"dealSyncRoleOpsBatch"})
    public AuthOpsSyncRoleBatchBusiRspBo dealSyncRoleOpsBatch(@RequestBody AuthOpsSyncRoleBatchBusiReqBo reqBo) {
        List<String> errorList = this.parameterValidationBatch(reqBo);
        if (!errorList.isEmpty()) {
            throw new ZTBusinessException("\u89d2\u8272\u540c\u6b65\u5931\u8d25:" + String.join((CharSequence)";", errorList));
        }
        if (Constants.OPS_C.equals(reqBo.getOpeType())) {
            return this.dealBatchRoleCreate(reqBo);
        }
        if (Constants.OPS_U.equals(reqBo.getOpeType())) {
            return this.dealBatchRoleUpdate(reqBo);
        }
        if (Constants.OPS_D.equals(reqBo.getOpeType())) {
            throw new ZTBusinessException("\u89d2\u8272\u540c\u6b65\u5931\u8d25:\u4e0d\u5141\u8bb8\u5220\u9664\u89d2\u8272");
        }
        throw new ZTBusinessException("\u89d2\u8272\u540c\u6b65\u5931\u8d25:\u672a\u77e5\u64cd\u4f5c\u7c7b\u578b");
    }

    private AuthOpsSyncRoleBatchBusiRspBo dealBatchRoleUpdate(AuthOpsSyncRoleBatchBusiReqBo reqBo) {
        List roleList = reqBo.getRoleList();
        List authIdentityList = roleList.stream().map(AuthOpsSyncRoleBatchBo::getOpsAuthIdentity).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(authIdentityList)) {
            throw new ZTBusinessException("\u89d2\u8272\u66f4\u65b0\u5931\u8d25:\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a");
        }
        List roleNameList = roleList.stream().map(AuthOpsSyncRoleBatchBo::getOpsRoleName).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(roleNameList)) {
            throw new ZTBusinessException("\u89d2\u8272\u66f4\u65b0\u5931\u8d25:\u89d2\u8272\u540d\u79f0\u4e3a\u7a7a");
        }
        HashMap<String, List<Role>> mapRole = new HashMap<String, List<Role>>();
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("authIdentityList", authIdentityList);
        List<Role> roles = this.roleMapper.selectByRecord(record);
        if (!CollectionUtils.isEmpty(roles)) {
            mapRole.putAll(roles.stream().collect(Collectors.groupingBy(Role::getAuthIdentity)));
        }
        for (AuthOpsSyncRoleBatchBo item : roleList) {
            if (mapRole.containsKey(item.getOpsAuthIdentity())) {
                List roleOldList = (List)mapRole.get(item.getOpsAuthIdentity());
                if (roleOldList.size() > 1) {
                    throw new ZTBusinessException("\u89d2\u8272\u66f4\u65b0\u5931\u8d25:\u89d2\u8272[" + item.getOpsAuthIdentity() + "]\u4e0d\u5b58\u5728.");
                }
                Role roleOld = (Role)roleOldList.get(0);
                if (!item.getOpsRoleName().equals(roleOld.getRoleName())) {
                    HashMap<String, Object> roleNameQry = new HashMap<String, Object>();
                    roleNameQry.put("roleName", item.getOpsRoleName());
                    List<Role> roleListName = this.roleMapper.selectByRecord(roleNameQry);
                    if (!CollectionUtils.isEmpty(roleListName)) {
                        throw new ZTBusinessException("\u89d2\u8272\u66f4\u65b0\u5931\u8d25:\u89d2\u8272\u540d\u79f0\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u53ef\u66f4\u65b0\u4e3a:" + item.getOpsRoleName());
                    }
                }
                Role roleUpdate = new Role();
                roleUpdate.setRoleId(roleOld.getRoleId());
                roleUpdate.setAuthIdentity(item.getOpsAuthIdentity());
                roleUpdate.setRoleName(item.getOpsRoleName());
                roleUpdate.setStatus(Constants.OPS_STATS_ENABLE.equals(item.getOpsStatus()) ? 0 : 1);
                roleUpdate.setUpdateTime(new Date());
                roleUpdate.setRemark(item.getRemark());
                int count = this.roleMapper.updateByPrimaryKey(roleUpdate);
                if (count <= 1) continue;
                throw new ZTBusinessException("\u89d2\u8272\u66f4\u65b0\u5931\u8d25:\u89d2\u8272[" + item.getOpsAuthIdentity() + "]\u66f4\u65b0\u5f02\u5e38\uff0ccount" + count);
            }
            throw new ZTBusinessException("\u89d2\u8272\u66f4\u65b0\u5931\u8d25:\u89d2\u8272[" + item.getOpsAuthIdentity() + "]\u4e0d\u5b58\u5728");
        }
        AuthOpsSyncRoleBatchBusiRspBo rspBo = new AuthOpsSyncRoleBatchBusiRspBo();
        rspBo.setCode("0");
        rspBo.setMessage("\u89d2\u8272\u6279\u91cf\u4fee\u6539\u6210\u529f");
        return rspBo;
    }

    private AuthOpsSyncRoleBatchBusiRspBo dealBatchRoleCreate(AuthOpsSyncRoleBatchBusiReqBo reqBo) {
        ArrayList<String> errorList = new ArrayList<String>();
        List roleList = reqBo.getRoleList();
        List authIdentityList = roleList.stream().map(AuthOpsSyncRoleBatchBo::getOpsAuthIdentity).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(authIdentityList)) {
            throw new ZTBusinessException("\u89d2\u8272\u540c\u6b65\u5931\u8d25:\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a");
        }
        List roleNameList = roleList.stream().map(AuthOpsSyncRoleBatchBo::getOpsRoleName).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(roleNameList)) {
            throw new ZTBusinessException("\u89d2\u8272\u540c\u6b65\u5931\u8d25:\u89d2\u8272\u540d\u79f0\u4e3a\u7a7a");
        }
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("authIdentityList", authIdentityList);
        List<Role> roles = this.roleMapper.selectByRecord(record);
        if (!CollectionUtils.isEmpty(roles)) {
            throw new ZTBusinessException("\u89d2\u8272\u65b0\u589e\u5931\u8d25:\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u91cd\u590d" + roles.stream().map(Role::getAuthIdentity).collect(Collectors.toList()));
        }
        record = new HashMap();
        record.put("roleNameList", roleNameList);
        roles = this.roleMapper.selectByRecord(record);
        if (!CollectionUtils.isEmpty(roles)) {
            throw new ZTBusinessException("\u89d2\u8272\u65b0\u589e\u5931\u8d25:\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u91cd\u590d" + roles.stream().map(Role::getRoleName).collect(Collectors.toList()));
        }
        for (AuthOpsSyncRoleBatchBo item : roleList) {
            Role roleInsert = new Role();
            roleInsert.setRoleId(Sequence.getInstance().nextId());
            roleInsert.setRemark(item.getRemark());
            roleInsert.setRoleName(item.getOpsRoleName());
            roleInsert.setStatus(Constants.OPS_STATS_ENABLE.equals(item.getOpsStatus()) ? 0 : 1);
            roleInsert.setAuthIdentity(item.getOpsAuthIdentity());
            roleInsert.setTenantId(reqBo.getTenantIdReq());
            if (reqBo.getTenantIdReq() == null) {
                roleInsert.setRoleType(Constants.ORG_TYPE_OVERALL);
                roleInsert.setOrgTreePath(null);
            } else {
                roleInsert.setRoleType(Constants.ORG_TYPE_TENANT);
                OrganisationPO organisationPo = this.organizationMapper.selectOrgByTenantId(reqBo.getTenantIdReq());
                if (organisationPo != null) {
                    roleInsert.setOrgTreePath(organisationPo.getOrgTreePath());
                } else {
                    errorList.add("\u79df\u6237[" + reqBo.getTenantIdReq() + "]\u67e5\u8be2\u673a\u6784\u4e3a\u7a7a");
                }
            }
            if (!errorList.isEmpty()) {
                throw new ZTBusinessException("\u89d2\u8272\u65b0\u589e\u5931\u8d25:" + String.join((CharSequence)";", errorList));
            }
            this.roleMapper.creatRole(roleInsert);
        }
        AuthOpsSyncRoleBatchBusiRspBo rspBo = new AuthOpsSyncRoleBatchBusiRspBo();
        rspBo.setCode("0");
        rspBo.setMessage("\u89d2\u8272\u6279\u91cf\u65b0\u589e\u6210\u529f");
        return rspBo;
    }

    private AuthOpsSyncRoleBusiRspBo dealRoleDelete(AuthOpsSyncRoleBusiReqBo reqBo) {
        Role role = this.roleMapper.selectByPrimaryKey(reqBo.getOpsRoleId());
        if (role == null) {
            throw new ZTBusinessException("\u89d2\u8272\u540c\u6b65\u5931\u8d25:\u5220\u9664\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        Boolean aBoolean = this.roleMapper.checkRoleHasUse(reqBo.getOpsRoleId());
        if (aBoolean.booleanValue()) {
            throw new ZTBusinessException("\u89d2\u8272\u540c\u6b65\u5931\u8d25\uff1a\u89d2\u8272\u5df2\u88ab\u4f7f\u7528,\u4e0d\u80fd\u5220\u9664");
        }
        this.orgRoleMapper.deleteByOrgRoleAndRole(reqBo.getOpsRoleId());
        this.orgRoleMenuMapper.deleteByRoleId(reqBo.getOpsRoleId());
        this.roleMapper.deleteRole(reqBo.getOpsRoleId());
        AuthOpsSyncRoleBusiRspBo rspBo = new AuthOpsSyncRoleBusiRspBo();
        rspBo.setCode("0");
        rspBo.setMessage("\u89d2\u8272\u5220\u9664\u6210\u529f");
        return rspBo;
    }

    private AuthOpsSyncRoleBusiRspBo dealRoleUpdate(AuthOpsSyncRoleBusiReqBo reqBo) {
        Role role = this.roleMapper.selectByPrimaryKey(reqBo.getOpsRoleId());
        if (role == null) {
            throw new ZTBusinessException("\u89d2\u8272\u540c\u6b65\u5931\u8d25:\u4fee\u6539\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        if (!role.getAuthIdentity().equals(reqBo.getOpsAuthIdentity())) {
            throw new ZTBusinessException("\u89d2\u8272\u540c\u6b65\u5931\u8d25:\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        }
        AuthOpsSyncRoleBusiRspBo rspBo = new AuthOpsSyncRoleBusiRspBo();
        rspBo.setCode("0");
        rspBo.setMessage("\u89d2\u8272\u66f4\u65b0\u672a\u5904\u7406");
        return rspBo;
    }

    private AuthOpsSyncRoleBusiRspBo dealRoleCreate(AuthOpsSyncRoleBusiReqBo reqBo) {
        ArrayList<String> errorList = new ArrayList<String>();
        Role role = this.roleMapper.selectByPrimaryKey(reqBo.getOpsRoleId());
        if (role != null) {
            errorList.add("\u65b0\u589e\u7684\u89d2\u8272ID[" + reqBo.getOpsRoleId() + "]\u5df2\u5b58\u5728");
        }
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("tenantId", reqBo.getTenantIdReq());
        record.put("roleName", reqBo.getOpsRoleName());
        List<Role> roles = this.roleMapper.selectByRecord(record);
        if (!CollectionUtils.isEmpty(roles)) {
            errorList.add("\u89d2\u8272\u540d\u79f0[" + reqBo.getOpsRoleName() + "]\u4e0d\u80fd\u91cd\u590d");
        }
        SelectIdentityRepeatReqBO repeatReqBo = new SelectIdentityRepeatReqBO();
        repeatReqBo.setAuthIdentity(reqBo.getOpsAuthIdentity());
        repeatReqBo.setTenantId(reqBo.getTenantIdReq());
        List<Role> identityRepeatBo = this.roleMapper.selectIdentityRepeat(repeatReqBo);
        if (!CollectionUtils.isEmpty(identityRepeatBo)) {
            errorList.add("\u6743\u9650\u6807\u5fd7[" + reqBo.getOpsAuthIdentity() + "]\u4e0d\u80fd\u91cd\u590d");
        }
        Role roleInsert = new Role();
        roleInsert.setRemark("OPS");
        roleInsert.setRoleId(reqBo.getOpsRoleId());
        roleInsert.setRoleName(reqBo.getOpsRoleName());
        roleInsert.setStatus("1".equals(reqBo.getOpsStatus()) ? 0 : 1);
        roleInsert.setCreateUserId(reqBo.getCreateUserId());
        roleInsert.setCreateTime(reqBo.getCreateTime());
        roleInsert.setAuthIdentity(reqBo.getOpsAuthIdentity());
        roleInsert.setTenantId(reqBo.getTenantIdReq());
        if (reqBo.getTenantIdReq() == null) {
            roleInsert.setRoleType(Constants.ORG_TYPE_OVERALL);
            roleInsert.setOrgTreePath(null);
        } else {
            roleInsert.setRoleType(Constants.ORG_TYPE_TENANT);
            OrganisationPO organisationPo = this.organizationMapper.selectOrgByTenantId(reqBo.getTenantIdReq());
            if (organisationPo != null) {
                roleInsert.setOrgTreePath(organisationPo.getOrgTreePath());
            } else {
                errorList.add("\u79df\u6237[" + reqBo.getTenantIdReq() + "]\u67e5\u8be2\u673a\u6784\u4e3a\u7a7a");
            }
        }
        if (!errorList.isEmpty()) {
            throw new ZTBusinessException("\u89d2\u8272\u540c\u6b65\u5931\u8d25:" + String.join((CharSequence)";", errorList));
        }
        this.roleMapper.creatRole(roleInsert);
        AuthOpsSyncRoleBusiRspBo rspBo = new AuthOpsSyncRoleBusiRspBo();
        rspBo.setCode("0");
        rspBo.setMessage("\u89d2\u8272\u65b0\u589e\u6210\u529f");
        return rspBo;
    }

    private List<String> parameterValidation(AuthOpsSyncRoleBusiReqBo reqBo) {
        ArrayList<String> errorList = new ArrayList<String>();
        if (reqBo == null) {
            errorList.add("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            return errorList;
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOpeType()) || !Arrays.asList(Constants.OPS_C, Constants.OPS_U, Constants.OPS_D).contains(reqBo.getOpeType())) {
            errorList.add("\u64cd\u4f5c\u7c7b\u578b[opeType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOpsRoleId() == null || reqBo.getOpsRoleId() == 0L) {
            errorList.add("\u89d2\u8272ID[roleId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOpsRoleName())) {
            errorList.add("\u89d2\u8272\u540d\u79f0[roleName]\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (!reqBo.getOpsRoleName().matches("[\\u4e00-\\u9fa5a-zA-Z0-9]+")) {
            errorList.add("\u89d2\u8272\u540d\u79f0[" + reqBo.getOpsRoleName() + "]\u9519\u8bef,\u53ea\u80fd\u8f93\u5165\u6c49\u5b57\u5b57\u6bcd\u548c\u6570\u5b57");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOpsAuthIdentity())) {
            errorList.add("\u6743\u9650\u7f16\u7801[authIdentity]\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (!reqBo.getOpsAuthIdentity().matches("[a-zA-Z0-9:_-]+")) {
            errorList.add("\u6743\u9650\u7f16\u7801[" + reqBo.getOpsAuthIdentity() + "]\u9519\u8bef,\u53ea\u53ef\u8f93\u5165\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u4e0e\":\"\u548c\"-\"\u7684\u7ed3\u5408\uff0c\u5982\uff1asystem:123:menu");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getGroupType())) {
            errorList.add("\u89d2\u8272\u7c7b\u578b[groupType]\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            if (!Arrays.asList(Constants.OPS_ROLE_TYPE_ALL, Constants.OPS_ROLE_TYPE_PRIV).contains(reqBo.getGroupType())) {
                errorList.add("\u89d2\u8272\u7c7b\u578b[" + reqBo.getGroupType() + "]\u9519\u8bef");
            }
            if (Constants.OPS_ROLE_TYPE_PRIV.equals(reqBo.getGroupType()) && reqBo.getTenantIdReq() == null) {
                errorList.add("\u79df\u6237\u89d2\u8272\u79df\u6237id[tenantIdReq]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOpsStatus())) {
            errorList.add("\u89d2\u8272\u72b6\u6001[opsStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (!Arrays.asList(Constants.OPS_STATS_DISABLE, Constants.OPS_STATS_ENABLE).contains(reqBo.getOpsStatus())) {
            errorList.add("\u89d2\u8272\u72b6\u6001[" + reqBo.getOpsStatus() + "]\u503c\u9519\u8bef");
        }
        return errorList;
    }

    private List<String> parameterValidationBatch(AuthOpsSyncRoleBatchBusiReqBo reqBo) {
        ArrayList<String> errorList = new ArrayList<String>();
        if (reqBo == null) {
            errorList.add("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            return errorList;
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOpeType())) {
            errorList.add("\u64cd\u4f5c\u7c7b\u578b[opeType]\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (!Arrays.asList(Constants.OPS_C, Constants.OPS_U).contains(reqBo.getOpeType())) {
            errorList.add("\u64cd\u4f5c\u7c7b\u578b[opeType]\u9519\u8bef\uff0c\u53ea\u80fd\u65b0\u589e\u548c\u4fee\u6539");
        }
        ArrayList<String> opsAuthIdentityList = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)reqBo.getRoleList())) {
            errorList.add("\u89d2\u8272\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a[roleList]\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            for (AuthOpsSyncRoleBatchBo item : reqBo.getRoleList()) {
                if (StringUtils.isBlank((CharSequence)item.getOpsRoleName())) {
                    errorList.add("\u89d2\u8272\u540d\u79f0[roleName]\u4e0d\u80fd\u4e3a\u7a7a");
                } else if (!item.getOpsRoleName().matches("[\\u4e00-\\u9fa5a-zA-Z0-9]+")) {
                    errorList.add("\u89d2\u8272\u540d\u79f0[" + item.getOpsRoleName() + "]\u9519\u8bef,\u53ea\u80fd\u8f93\u5165\u6c49\u5b57\u5b57\u6bcd\u548c\u6570\u5b57");
                }
                if (StringUtils.isBlank((CharSequence)item.getOpsAuthIdentity())) {
                    errorList.add("\u6743\u9650\u7f16\u7801[authIdentity]\u4e0d\u80fd\u4e3a\u7a7a");
                } else if (!item.getOpsAuthIdentity().matches("[a-zA-Z0-9:_-]+")) {
                    errorList.add("\u6743\u9650\u7f16\u7801[" + item.getOpsAuthIdentity() + "]\u9519\u8bef,\u53ea\u53ef\u8f93\u5165\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u4e0e\":\"\u548c\"-\"\u7684\u7ed3\u5408\uff0c\u5982\uff1asystem:123:menu");
                } else if (opsAuthIdentityList.contains(item.getOpsAuthIdentity())) {
                    errorList.add("\u6743\u9650\u7f16\u7801[authIdentity=" + item.getOpsAuthIdentity() + "]\u91cd\u590d");
                } else {
                    opsAuthIdentityList.add(item.getOpsAuthIdentity());
                }
                if (StringUtils.isBlank((CharSequence)item.getOpsStatus())) {
                    errorList.add("\u89d2\u8272\u72b6\u6001[opsStatus]\u4e0d\u80fd\u4e3a\u7a7a");
                    continue;
                }
                if (Arrays.asList(Constants.OPS_STATS_DISABLE, Constants.OPS_STATS_ENABLE).contains(item.getOpsStatus())) continue;
                errorList.add("\u89d2\u8272\u72b6\u6001[" + item.getOpsStatus() + "]\u503c\u9519\u8bef");
            }
        }
        return errorList;
    }
}

