/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.opsrole;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.mq.bo.DelRoleSendMsgReqBO;
import com.ohaotian.authority.mq.service.DelRoleSendMsgService;
import com.ohaotian.authority.opsrole.AuthOpsSyncRoleUserBusiService;
import com.ohaotian.authority.opsrole.bo.AuthOpsSyncRoleUserBatchBusiReqBo;
import com.ohaotian.authority.opsrole.bo.AuthOpsSyncRoleUserBatchBusiRspBo;
import com.ohaotian.authority.opsrole.bo.AuthOpsSyncRoleUserBo;
import com.ohaotian.authority.opsrole.bo.AuthOpsSyncRoleUserBusiReqBo;
import com.ohaotian.authority.opsrole.bo.AuthOpsSyncRoleUserBusiRspBo;
import com.ohaotian.authority.po.AuthDistribute;
import com.ohaotian.authority.po.Role;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.role.bo.AuthDistributeBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.opsrole.AuthOpsSyncRoleUserBusiService"})
public class AuthOpsSyncRoleUserBusiServiceImpl
implements AuthOpsSyncRoleUserBusiService {
    private static final Logger log = LoggerFactory.getLogger(AuthOpsSyncRoleUserBusiServiceImpl.class);
    @Resource
    private RoleMapper roleMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private AuthDistributeMapper authDistributeMapper;
    @Resource
    private DelRoleSendMsgService delRoleSendMsgService;
    @Value(value="${ROLE_DEL_IS_SEND_MSG:0}")
    private String ROLE_DEL_IS_SEND_MSG;

    @Deprecated
    @Transactional
    @PostMapping(value={"dealSyncRoleUserOps"})
    public AuthOpsSyncRoleUserBusiRspBo dealSyncRoleUserOps(@RequestBody AuthOpsSyncRoleUserBusiReqBo reqBo) {
        Long userId;
        Long roleId;
        ArrayList<String> errorMsg = new ArrayList<String>();
        if (reqBo == null) {
            throw new ZTBusinessException("\u89d2\u8272\u7528\u6237\u540c\u6b65\u5931\u8d25:\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOpeType()) || !Arrays.asList(Constants.OPS_C, Constants.OPS_D).contains(reqBo.getOpeType())) {
            errorMsg.add("\u64cd\u4f5c\u7c7b\u578b[opeType]\u9519\u8bef\u6216\u4e3a\u7a7a");
        }
        if ((roleId = reqBo.getOpsRoleId()) == null || roleId == 0L) {
            errorMsg.add("\u89d2\u8272ID[opsRoleId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((userId = reqBo.getOpsUserId()) == null || userId == 0L) {
            errorMsg.add("\u89d2\u8272ID[opsUserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!errorMsg.isEmpty()) {
            throw new ZTBusinessException("\u89d2\u8272\u7528\u6237\u540c\u6b65\u5931\u8d25:" + String.join((CharSequence)";", errorMsg));
        }
        if (Constants.OPS_C.equals(reqBo.getOpeType())) {
            Role role = this.roleMapper.selectByPrimaryKey(roleId);
            if (role == null) {
                throw new ZTBusinessException("\u89d2\u8272\u7528\u6237\u540c\u6b65\u5931\u8d25:\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u89d2\u8272\u4e3a\u7a7a");
            }
            UserPO userPo = this.userMapper.selectUserInfo(userId);
            if (userPo == null) {
                throw new ZTBusinessException("\u89d2\u8272\u7528\u6237\u540c\u6b65\u5931\u8d25:\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u7528\u6237\u4e3a\u7a7a");
            }
            AuthDistribute authDistribute = new AuthDistribute();
            authDistribute.setAuthId(Sequence.getInstance().nextId());
            authDistribute.setUserId(userId);
            authDistribute.setRoleId(roleId);
            authDistribute.setDisFlag(Constants.AUTH_USER);
            this.authDistributeMapper.insert(authDistribute);
        } else if (Constants.OPS_D.equals(reqBo.getOpeType())) {
            ArrayList<Long> userIds = new ArrayList<Long>();
            AuthDistributeBO authDistributeBO = new AuthDistributeBO();
            authDistributeBO.setUserId(userId);
            authDistributeBO.setRoleId(roleId);
            this.authDistributeMapper.deleteRoleByUserId(authDistributeBO);
            userIds.add(userId);
            if (this.ROLE_DEL_IS_SEND_MSG.equals("1")) {
                DelRoleSendMsgReqBO delRoleSendMsgReqBO = new DelRoleSendMsgReqBO();
                delRoleSendMsgReqBO.setRoleId(roleId);
                delRoleSendMsgReqBO.setUserIds(userIds);
                this.delRoleSendMsgService.delRoleSendMsg(delRoleSendMsgReqBO);
            }
        }
        AuthOpsSyncRoleUserBusiRspBo rspBo = new AuthOpsSyncRoleUserBusiRspBo();
        rspBo.setCode("0");
        rspBo.setMessage("\u89d2\u8272\u7528\u6237\u540c\u6b65\u6210\u529f");
        return rspBo;
    }

    @Transactional
    @PostMapping(value={"dealSyncRoleUserOpsBatch"})
    public AuthOpsSyncRoleUserBatchBusiRspBo dealSyncRoleUserOpsBatch(@RequestBody AuthOpsSyncRoleUserBatchBusiReqBo reqBo) {
        ArrayList<String> errorMsg = new ArrayList<String>();
        if (reqBo == null) {
            throw new ZTBusinessException("\u89d2\u8272\u7528\u6237\u6279\u91cf\u540c\u6b65\u5931\u8d25:\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOpeType()) || !Arrays.asList(Constants.OPS_C, Constants.OPS_D).contains(reqBo.getOpeType())) {
            errorMsg.add("\u64cd\u4f5c\u7c7b\u578b[opeType]\u9519\u8bef\u6216\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getRoleUserList())) {
            errorMsg.add("\u89d2\u8272\u7528\u6237\u96c6\u5408[roleUserList]\u4e3a\u7a7a");
        } else {
            int index = 0;
            ArrayList<String> roleUserKey = new ArrayList<String>();
            for (AuthOpsSyncRoleUserBo item : reqBo.getRoleUserList()) {
                String key;
                if (StringUtils.isBlank((CharSequence)item.getOpsRoleCode())) {
                    errorMsg.add("\u7b2c" + index + "\u884c\u89d2\u8272\u7f16\u7801[roleUserList.opsRoleCode]\u4e3a\u7a7a");
                }
                if (item.getOpsUserId() == null || item.getOpsUserId() == 0L) {
                    errorMsg.add("\u7b2c" + index + "\u884c\u83dc\u5355ID[roleUserList.opsUserId]\u4e3a\u7a7a");
                }
                if (roleUserKey.contains(key = item.getOpsRoleCode() + "-" + item.getOpsUserId())) {
                    errorMsg.add("\u7b2c" + index + "\u884c\u89d2\u8272code+\u7528\u6237ID\u91cd\u590d" + key);
                } else {
                    roleUserKey.add(key);
                }
                ++index;
            }
        }
        if (!errorMsg.isEmpty()) {
            throw new ZTBusinessException("\u89d2\u8272\u7528\u6237\u6279\u91cf\u540c\u6b65\u5931\u8d25:" + String.join((CharSequence)";", errorMsg));
        }
        List roleCodeList = reqBo.getRoleUserList().stream().map(AuthOpsSyncRoleUserBo::getOpsRoleCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List userIdList = reqBo.getRoleUserList().stream().map(AuthOpsSyncRoleUserBo::getOpsUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(roleCodeList)) {
            throw new ZTBusinessException("\u89d2\u8272\u7528\u6237\u6279\u91cf\u540c\u6b65\u5931\u8d25:\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(userIdList)) {
            throw new ZTBusinessException("\u89d2\u8272\u7528\u6237\u6279\u91cf\u540c\u6b65\u5931\u8d25:\u83dc\u5355ID\u4e3a\u7a7a");
        }
        HashMap<String, Long> mapRoleCodeAndId = new HashMap<String, Long>();
        ArrayList<Long> userExit = new ArrayList<Long>();
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("authIdentityList", new ArrayList(roleCodeList));
        List<Role> roles = this.roleMapper.selectByRecord(record);
        if (!CollectionUtils.isEmpty(roles)) {
            mapRoleCodeAndId.putAll(roles.stream().collect(Collectors.toMap(Role::getAuthIdentity, Role::getRoleId, (c, n) -> c)));
        }
        for (Object userId : userIdList) {
            UserPO userPo = this.userMapper.selectUserInfo((Long)userId);
            if (userPo == null) continue;
            userExit.add((Long)userId);
        }
        log.error("mapRoleCodeAndId:{}.userExit:{}.roleUserList:{}", new Object[]{mapRoleCodeAndId, userExit, reqBo.getRoleUserList()});
        HashMap mapDelRoleUser = new HashMap();
        for (AuthOpsSyncRoleUserBo bo : reqBo.getRoleUserList()) {
            String roleCode = bo.getOpsRoleCode();
            Long userId = bo.getOpsUserId();
            Long roleId = (Long)mapRoleCodeAndId.get(roleCode);
            if (userExit.contains(userId) && roleId != null) {
                AuthDistribute authDistributeOld = this.authDistributeMapper.selectByUserIdAndRoleId(userId, roleId);
                if (Constants.OPS_C.equals(reqBo.getOpeType())) {
                    if (authDistributeOld != null) continue;
                    AuthDistribute authDistribute = new AuthDistribute();
                    authDistribute.setAuthId(Sequence.getInstance().nextId());
                    authDistribute.setUserId(userId);
                    authDistribute.setRoleId(roleId);
                    authDistribute.setDisFlag(Constants.AUTH_USER);
                    this.authDistributeMapper.insert(authDistribute);
                    continue;
                }
                if (!Constants.OPS_D.equals(reqBo.getOpeType()) || authDistributeOld == null) continue;
                this.authDistributeMapper.deleteRoleByUserIdAndRole(userId, roleId);
                if (mapDelRoleUser.containsKey(roleId)) {
                    ((List)mapDelRoleUser.get(roleId)).add(userId);
                    continue;
                }
                mapDelRoleUser.put(roleId, Stream.of(userId).collect(Collectors.toList()));
                continue;
            }
            throw new ZTBusinessException("\u89d2\u8272\u7528\u6237\u6279\u91cf\u540c\u6b65\u5931\u8d25:\u89d2\u8272\u7f16\u7801[" + roleCode + "]\u6216\u7528\u6237[" + userId + "]\u4e0d\u5b58\u5728");
        }
        if (this.ROLE_DEL_IS_SEND_MSG.equals("1") && Constants.OPS_D.equals(reqBo.getOpeType()) && !mapDelRoleUser.isEmpty()) {
            for (Map.Entry del : mapDelRoleUser.entrySet()) {
                DelRoleSendMsgReqBO delRoleSendMsgReqBO = new DelRoleSendMsgReqBO();
                delRoleSendMsgReqBO.setRoleId((Long)del.getKey());
                delRoleSendMsgReqBO.setUserIds((List)del.getValue());
                this.delRoleSendMsgService.delRoleSendMsg(delRoleSendMsgReqBO);
            }
        }
        AuthOpsSyncRoleUserBatchBusiRspBo rspBo = new AuthOpsSyncRoleUserBatchBusiRspBo();
        rspBo.setCode("0");
        rspBo.setMessage("\u89d2\u8272\u7528\u6237\u6279\u91cf\u540c\u6b65\u6210\u529f");
        return rspBo;
    }
}

