/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.menu;

import com.ohaotian.authority.dao.MenuMapper;
import com.ohaotian.authority.menu.bo.ChangeMenuSortInfoBO;
import com.ohaotian.authority.menu.bo.ChangeMenuSortReqBO;
import com.ohaotian.authority.menu.service.ChangeMenuOrderBusiService;
import com.ohaotian.authority.po.Menu;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.menu.service.ChangeMenuOrderBusiService"})
public class ChangeMenuOrderBusiServiceImpl
implements ChangeMenuOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(ChangeMenuOrderBusiServiceImpl.class);
    @Autowired
    private MenuMapper menuMapper;

    @PostMapping(value={"sortMenu"})
    public void sortMenu(@RequestBody ChangeMenuSortReqBO reqBO) {
        this.validateArg(reqBO);
        Date now = new Date();
        Long userId = reqBO.getUserId();
        for (ChangeMenuSortInfoBO menu : reqBO.getDycAuthMenuInfoBos()) {
            Menu update = new Menu();
            update.setMenuId(menu.getMenuId());
            update.setOrder(menu.getSort());
            update.setUpdateTime(now);
            update.setUpdateUserId(userId);
            this.menuMapper.updateByPrimaryKey(update);
        }
    }

    private void validateArg(ChangeMenuSortReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getDycAuthMenuInfoBos())) {
            throw new ZTBusinessException("\u5165\u53c2[dycAuthMenuInfoBos]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

