/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.menu;

import com.ohaotian.authority.dao.MenuMapper;
import com.ohaotian.authority.menu.bo.CreateMenuCatalogReqBO;
import com.ohaotian.authority.menu.bo.CreateMenuCatalogRspBO;
import com.ohaotian.authority.menu.service.CreateMenuCatalogBusiService;
import com.ohaotian.authority.po.Menu;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.menu.service.CreateMenuCatalogBusiService"})
public class CreateMenuCatalogBusiServiceImpl
implements CreateMenuCatalogBusiService {
    private static final Logger log = LoggerFactory.getLogger(CreateMenuCatalogBusiServiceImpl.class);
    @Autowired
    private MenuMapper menuMapper;
    private Sequence sequence = Sequence.getInstance();

    @Transactional
    @PostMapping(value={"createMenu"})
    public CreateMenuCatalogRspBO createMenu(@RequestBody CreateMenuCatalogReqBO reqBO) {
        this.validateArg(reqBO);
        Menu menu = this.menuMapper.selectByMenuCode(reqBO.getMenuCode(), reqBO.getApplicationCode());
        if (menu != null) {
            throw new ZTBusinessException("\u83dc\u5355\u7f16\u7801\u91cd\u590d");
        }
        Menu createDo = new Menu();
        BeanUtils.copyProperties((Object)reqBO, (Object)createDo);
        createDo.setMenuId(this.sequence.nextId());
        createDo.setType(reqBO.getMenuType());
        createDo.setCreateTime(new Date());
        createDo.setCreateUserId(reqBO.getUserId());
        createDo.setStatus(1);
        createDo.setUrl(reqBO.getMenuUri());
        createDo.setIcon(reqBO.getMenuIcon());
        createDo.setMenuDomain(reqBO.getDomainCode());
        if (reqBO.getParentId() != null) {
            Menu parentMenu = this.menuMapper.selectByPrimaryKey(reqBO.getParentId());
            if (parentMenu == null) {
                throw new ZTBusinessException("\u7236\u7ea7\u83dc\u5355\u4e0d\u5b58\u5728");
            }
            String menuTreePath = parentMenu.getMenuTreePath() + createDo.getMenuId() + "-";
            createDo.setMenuTreePath(menuTreePath);
            Integer deep = parentMenu.getDeep() + 1;
            createDo.setDeep(deep);
            String authIdentity = parentMenu.getAuthIdentity() + ":" + createDo.getMenuCode();
            createDo.setAuthIdentity(authIdentity);
            this.menuMapper.addSublevelMenu(createDo);
        } else {
            createDo.setMenuTreePath("-" + createDo.getMenuId() + "-");
            createDo.setDeep(1);
            createDo.setAuthIdentity(createDo.getMenuCode());
            this.menuMapper.addMenuCatalog(createDo);
        }
        return new CreateMenuCatalogRspBO();
    }

    private void validateArg(CreateMenuCatalogReqBO reqBo) {
        if (reqBo == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[CreateMenuCatalogReqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getMenuCode())) {
            throw new ZTBusinessException("\u5165\u53c2[menuCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getMenuName())) {
            throw new ZTBusinessException("\u5165\u53c2[menuName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

