/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.menu;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.MenuMapper;
import com.ohaotian.authority.menu.bo.MenuBO;
import com.ohaotian.authority.menu.bo.SelectMenuTreeListReqBO;
import com.ohaotian.authority.menu.bo.SelectMenuTreeListRspBO;
import com.ohaotian.authority.menu.service.SelectMenuTreeListBusiService;
import com.ohaotian.authority.po.Menu;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.menu.service.SelectMenuTreeListBusiService"})
public class SelectMenuTreeListBusiServiceImpl
implements SelectMenuTreeListBusiService {
    private static final Logger log = LoggerFactory.getLogger(SelectMenuTreeListBusiServiceImpl.class);
    @Autowired
    private MenuMapper menuMapper;

    @PostMapping(value={"getMenuList"})
    public SelectMenuTreeListRspBO getMenuList(@RequestBody SelectMenuTreeListReqBO reqBO) {
        List<Menu> menus = this.menuMapper.selectMenuList(reqBO.getApplicationCode(), reqBO.getMenuName());
        LinkedList<MenuBO> menuBOList = new LinkedList<MenuBO>();
        if (!CollectionUtils.isEmpty(menus)) {
            List menuList = JSON.parseArray((String)JSON.toJSONString(menus), MenuBO.class);
            for (MenuBO menu : menuList) {
                menu.setMenuStatus(menu.getStatus());
                menu.setMenuIcon(menu.getIcon());
                menu.setSort(menu.getOrder());
                menu.setMenuUri(menu.getUrl());
                menu.setDomainCode(menu.getMenuDomain());
                if (menu.getParentId() != null) continue;
                menuBOList.add(this.findChildren(menu, menuList));
            }
        }
        SelectMenuTreeListRspBO rspBO = new SelectMenuTreeListRspBO();
        rspBO.setMenuInfoBoList(menuBOList);
        rspBO.setApplicationCode(reqBO.getApplicationCode());
        log.info("\u67e5\u8be2\u83dc\u5355\u5217\u8868\u51fa\u53c2:" + JSON.toJSONString((Object)rspBO));
        return rspBO;
    }

    private MenuBO findChildren(MenuBO root, List<MenuBO> allMenus) {
        for (MenuBO allMenu : allMenus) {
            if (!root.getMenuId().equals(allMenu.getParentId())) continue;
            if (root.getChildren() == null) {
                root.setChildren(new ArrayList());
            }
            if (allMenu.getType().equals(Constants.MENU_TYPE_F)) continue;
            root.getChildren().add(this.findChildren(allMenu, allMenus));
        }
        return root;
    }
}

