/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.user.bo.DeleteUserReqBO;
import com.ohaotian.authority.user.service.DeleteUserService;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.user.service.DeleteUserService"})
public class DeleteUserServiceImpl
implements DeleteUserService {
    private static final Logger log = LoggerFactory.getLogger(DeleteUserServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private AuthDistributeMapper authDistributeMapper;
    @Resource(name="dataSend")
    private ProxyMessageProducer dataSend;
    @Value(value="${mq.authority.datasend.topic}")
    private String dataSendTopic;

    @Transactional
    @PostMapping(value={"deleteUserByUserId"})
    public void deleteUserByUserId(@RequestBody DeleteUserReqBO userReqBO) {
        userReqBO.setUserId(userReqBO.getUserIdWeb());
        UserPO userPO = this.userMapper.selectUserInfo(userReqBO.getUserId());
        this.userMapper.deleteUserByUserId(userReqBO.getUserId());
        this.userMapper.deleteByExtSysUser(userReqBO.getUserId());
        this.userMapper.deleteUserStation(userReqBO.getUserId());
        this.authDistributeMapper.deleteByUserId(userReqBO.getUserId());
        this.organizationMapper.updateMuserIdNull(userReqBO.getUserId());
        ProxyMessage proxyMessage = new ProxyMessage(this.dataSendTopic, "delete_" + Constants.MQ_DATA_SEND_TAG_USER + "_" + userPO.getTenantId(), userReqBO.getUserId() + "");
        this.dataSend.send(proxyMessage);
    }
}

